package com.instabug.apm.cache.model;

import androidx.annotation.Nullable;

import java.util.Map;

public class ExecutionTraceCacheModel {

    private long id;
    @Nullable
    private String name;
    private long startTime;
    private long duration;
    @Nullable
    private Map<String, String> attrs;
    private boolean startedInBackground;
    private boolean endedInBackground;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Nullable
    public String getName() {
        return name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getDuration() {
        return duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Nullable
    public Map<String, String> getAttrs() {
        return attrs;
    }

    public void setAttrs(@Nullable Map<String, String> attrs) {
        this.attrs = attrs;
    }

    public void setStartedInBackground(boolean startedInBackground) {
        this.startedInBackground = startedInBackground;
    }

    public void setEndedInBackground(boolean endedInBackground) {
        this.endedInBackground = endedInBackground;
    }

    public boolean startedInBackground() {
        return startedInBackground;
    }

    public boolean endedInBackground() {
        return endedInBackground;
    }

    public static class Builder {
        private final String name;
        private final long id;
        private long startTime;
        private long duration;
        @Nullable
        private Map<String, String> attrs;
        private boolean startedInBackground;
        private boolean endedInBackground;

        public Builder(String name, long id) {
            this.name = name;
            this.id = id;
        }

        public Builder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder setStartInBackground(boolean startedInBackground) {
            this.startedInBackground = startedInBackground;
            return this;
        }

        public Builder setEndedInBackground(boolean endedInBackground) {
            this.endedInBackground = endedInBackground;
            return this;
        }

        public Builder setAttrs(Map<String, String> attrs) {
            this.attrs = attrs;
            return this;
        }

        public ExecutionTraceCacheModel build() {
            ExecutionTraceCacheModel cacheModel = new ExecutionTraceCacheModel();
            cacheModel.setId(id);
            cacheModel.setName(name);
            cacheModel.setStartTime(startTime);
            cacheModel.setStartedInBackground(startedInBackground);
            cacheModel.setDuration(duration);
            cacheModel.setEndedInBackground(endedInBackground);
            cacheModel.setAttrs(attrs);
            return cacheModel;
        }
    }
}
