/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.sync;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider;
import com.instabug.apm.appflow.di.AppFlowServiceLocator;
import com.instabug.apm.appflow.model.AppFlowCacheModel;
import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandler;
import com.instabug.apm.cache.handler.uitrace.UiTraceCacheHandler;
import com.instabug.apm.cache.model.AppLaunchCacheModel;
import com.instabug.apm.cache.model.ExecutionTraceCacheModel;
import com.instabug.apm.cache.model.FragmentSpansCacheModel;
import com.instabug.apm.cache.model.SessionCacheModel;
import com.instabug.apm.cache.model.UiTraceCacheModel;
import com.instabug.apm.compose.compose_spans.ComposeSpansServiceLocator;
import com.instabug.apm.compose.compose_spans.configuration.ComposeSpansConfigurationProvider;
import com.instabug.apm.compose.compose_spans.handler.ComposeSpansHandler;
import com.instabug.apm.compose.compose_spans.model.ComposeSpansCacheModel;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.applaunch.AppLaunchesHandler;
import com.instabug.apm.handler.executiontraces.ExecutionTracesHandler;
import com.instabug.apm.handler.experiment.ExperimentHandler;
import com.instabug.apm.handler.fragment.FragmentSpansHandler;
import com.instabug.apm.handler.networklog.NetworkLogHandler;
import com.instabug.apm.handler.session.SessionHandler;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.networking.handler.SyncManagerNetworkHandler;
import com.instabug.apm.networking.mapping.sessions.SessionModelFiller;
import com.instabug.apm.sync.APMSyncManager;
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class APMSyncManagerImpl
implements APMSyncManager {
    private Logger apmLogger = ServiceLocator.getApmLogger();
    private APMConfigurationProvider apmConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
    private SessionHandler sessionHandler = ServiceLocator.getSessionHandler();
    @Nullable
    private SessionMetaDataCacheHandler sessionMetaDataCacheHandler;
    @NonNull
    private AppLaunchesHandler appLaunchesHandler;
    @NonNull
    private NetworkLogHandler networkLogHandler;
    @NonNull
    private ExecutionTracesHandler executionTracesHandler;
    @NonNull
    private UiTraceCacheHandler uiTraceHandler;
    @NonNull
    SyncManagerNetworkHandler syncManagerNetworkHandler;
    @Nullable
    private ExperimentHandler experimentHandler;
    @Nullable
    private FragmentSpansHandler fragmentSpansHandler;
    @VisibleForTesting
    public boolean shouldSetLastSyncTime = false;
    @VisibleForTesting
    public Request.Callbacks<RequestResponse, Throwable> callback = new Request.Callbacks<RequestResponse, Throwable>(){

        public void onSucceeded(RequestResponse object) {
            1 v0 = this;
            v0.APMSyncManagerImpl.this.sessionHandler.deleteSessionsBySyncStatus(0);
            v0.APMSyncManagerImpl.this.apmConfigurationProvider.setLastApmSessionsRequestStartedAt(0L);
            object = ServiceLocator.getApmStateProvider();
            if (object != null) {
                object.resetStoreLimitDroppedSessionCount();
            }
            APMSyncManagerImpl.this.syncNextSessionsChunk();
        }

        public void onFailed(Throwable throwable) {
            if (throwable instanceof RateLimitedException) {
                APMSyncManagerImpl.this.handleRateLimitException((RateLimitedException)throwable);
                return;
            }
            if (throwable != null && throwable.getMessage() != null) {
                APMSyncManagerImpl.this.apmLogger.e(throwable.getMessage());
            }
        }
    };

    public APMSyncManagerImpl() {
        this.sessionMetaDataCacheHandler = ServiceLocator.getSessionMetaDataCacheHandler();
        this.appLaunchesHandler = ServiceLocator.getAppLaunchesHandler();
        this.networkLogHandler = ServiceLocator.getNetworkLogHandler();
        this.executionTracesHandler = ServiceLocator.getExecutionTracesHandler();
        this.uiTraceHandler = ServiceLocator.getUiTraceCacheHandler();
        this.syncManagerNetworkHandler = ServiceLocator.getSyncManagerNetworkHandler();
        this.experimentHandler = ServiceLocator.getExperimentHandler();
        this.fragmentSpansHandler = ServiceLocator.getFragmentSpansHandler();
    }

    private boolean isDebugModeEnabled() {
        return this.apmConfigurationProvider.isDebugModeEnabled() && ServiceLocator.getDebugUtils().isInDebugMode();
    }

    private boolean isSyncIntervalPassed() {
        return System.currentTimeMillis() - this.apmConfigurationProvider.getLastSyncTime() >= this.apmConfigurationProvider.getSyncInterval() * 1000L;
    }

    private void syncNextSessionsChunk() {
        SessionCacheModel sessionCacheModel;
        ArrayList<SessionCacheModel> arrayList;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        ArrayList<SessionCacheModel> arrayList2 = arrayList;
        arrayList = new ArrayList<SessionCacheModel>();
        List<AppLaunchCacheModel> list = "-1";
        do {
            List<AppFlowCacheModel> list2;
            int n12;
            List<ComposeSpansCacheModel> list3;
            int n13;
            List<FragmentSpansCacheModel> list4;
            int n14;
            List<String> list5;
            int n15;
            if ((sessionCacheModel = this.getNextSession((String)((Object)list))) == null) continue;
            list = sessionCacheModel.getAppLaunches();
            if (list != null) {
                list = list.iterator();
                while (list.hasNext()) {
                    AppLaunchCacheModel appLaunchCacheModel = (AppLaunchCacheModel)list.next();
                    if ("warm".equals(appLaunchCacheModel.getType())) {
                        ++n2;
                        continue;
                    }
                    if ("cold".equals(appLaunchCacheModel.getType())) {
                        ++n;
                        continue;
                    }
                    ++n3;
                }
            }
            int n16 = (list = sessionCacheModel.getNetworkLogs()) != null ? list.size() : 0;
            List<UiTraceCacheModel> list6 = sessionCacheModel.getUiTraces();
            int n17 = list6 != null ? list6.size() : 0;
            List<ExecutionTraceCacheModel> list7 = sessionCacheModel.getExecutionTraces();
            int n18 = list7 != null ? list7.size() : 0;
            if (this.exceededRequestLimit(n3, n, n2, n4 += n16, n5 += n17, n6 += n18, n7 += (n15 = (list5 = sessionCacheModel.getExperiments()) != null ? list5.size() : 0), n8 += (n14 = (list4 = sessionCacheModel.getFragmentSpans()) != null ? list4.size() : 0), n9 += (n13 = (list3 = sessionCacheModel.getComposeSpans()) != null ? list3.size() : 0), n10 += sessionCacheModel.getWebViewTraceTotalCount(), n11 += (n12 = (list2 = sessionCacheModel.getAppFlows()) != null ? list2.size() : 0))) break;
            arrayList2.add(sessionCacheModel);
            list = sessionCacheModel.getId();
        } while (sessionCacheModel != null);
        APMSyncManagerImpl aPMSyncManagerImpl = this;
        aPMSyncManagerImpl.syncSessionsList(arrayList2);
        aPMSyncManagerImpl.apmLogger.logSDKDebug("syncNextSessionsChunk: " + arrayList2.size());
    }

    private boolean exceededRequestLimit(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        return (long)n > this.getLaunchLimitPerRequest("hot") || (long)n2 > this.getLaunchLimitPerRequest("cold") || (long)n3 > this.getLaunchLimitPerRequest("warm") || (long)n4 > this.apmConfigurationProvider.getNetworkLogsRequestLimit() || (long)n5 > this.apmConfigurationProvider.getUiTraceLimitPerRequest() || (long)n6 > this.apmConfigurationProvider.getExecutionTraceLimitPerRequest() || n7 > this.apmConfigurationProvider.getExperimentsLimitPerRequest() || n8 > this.apmConfigurationProvider.getFragmentSpansLimitPerRequest() || n9 > this.getComposeSpansRequestLimit() || n10 > this.getWebViewsRequestLimit() || n11 > this.getAppFlowRequestLimit();
    }

    private int getComposeSpansRequestLimit() {
        ComposeSpansConfigurationProvider composeSpansConfigurationProvider = APMSyncManagerImpl.getComposeConfigurations();
        return composeSpansConfigurationProvider != null ? composeSpansConfigurationProvider.getRequestLimit() : 200;
    }

    private int getWebViewsRequestLimit() {
        WebViewTraceConfigurationProvider webViewTraceConfigurationProvider = ServiceLocator.getWebViewTraceConfigurationProvider();
        return webViewTraceConfigurationProvider != null ? webViewTraceConfigurationProvider.getRequestLimit() : 200;
    }

    private int getAppFlowRequestLimit() {
        AppFlowConfigurationProvider appFlowConfigurationProvider = APMSyncManagerImpl.getAppFlowConfigurationProvider();
        return appFlowConfigurationProvider != null ? appFlowConfigurationProvider.getRequestLimit() : 200;
    }

    @Nullable
    private static AppFlowConfigurationProvider getAppFlowConfigurationProvider() {
        return AppFlowServiceLocator.INSTANCE.getConfigurationProvider();
    }

    private long getLaunchLimitPerRequest(String string) {
        return this.apmConfigurationProvider.getAppLaunchRequestLimit(string);
    }

    private void fillSessionModel(@Nullable SessionCacheModel sessionCacheModel) {
        if (sessionCacheModel != null) {
            String string = sessionCacheModel.getId();
            Object object = ((APMSyncManagerImpl)this).sessionMetaDataCacheHandler;
            if (object != null) {
                sessionCacheModel.setSessionMetaData(object.getSessionMetaData(string));
            }
            sessionCacheModel.setAppLaunches(((APMSyncManagerImpl)this).appLaunchesHandler.getAppLaunchesForSession(string));
            sessionCacheModel.setNetworkLogs(((APMSyncManagerImpl)this).networkLogHandler.getEndedNetworkLogsForSession(string));
            sessionCacheModel.setExecutionTraces(((APMSyncManagerImpl)this).executionTracesHandler.getExecutionTracesForSession(string));
            sessionCacheModel.setUiTraces(((APMSyncManagerImpl)this).uiTraceHandler.getUiTracesForSession(string));
            object = APMSyncManagerImpl.getComposeSpansHandler();
            if (object != null) {
                sessionCacheModel.setComposeSpans(object.getForSession(string));
            }
            if ((object = ((APMSyncManagerImpl)this).experimentHandler) != null) {
                sessionCacheModel.setExperiments(object.getSessionExperimentsAsync(string));
            }
            if ((this = ((APMSyncManagerImpl)this).fragmentSpansHandler) != null) {
                sessionCacheModel.setFragmentSpans(this.getFragmentsForSession(string));
            }
            APMSyncManagerImpl.fillSessionModelWithAppFlows(sessionCacheModel, string);
        }
    }

    private static void fillSessionModelWithAppFlows(@NonNull SessionCacheModel sessionCacheModel, String string) {
        SessionModelFiller sessionModelFiller = APMSyncManagerImpl.getAppFlowSessionModelFiller();
        if (sessionModelFiller != null) {
            sessionModelFiller.fill(string, sessionCacheModel);
        }
    }

    @Nullable
    private static SessionModelFiller getAppFlowSessionModelFiller() {
        return AppFlowServiceLocator.INSTANCE.getSessionModelFiller();
    }

    @Nullable
    private SessionCacheModel getNextSession(String object) {
        if ((object = this.sessionHandler.getNextSession((String)object)) != null) {
            this.fillSessionModel((SessionCacheModel)object);
        }
        return object;
    }

    private void handleRateLimitException(RateLimitedException rateLimitedException) {
        APMSyncManagerImpl aPMSyncManagerImpl = this;
        aPMSyncManagerImpl.apmConfigurationProvider.setApmSessionsLimitedUntil(rateLimitedException.getPeriod());
        aPMSyncManagerImpl.handleRateIsLimited();
    }

    private void syncSessionsList(@NonNull List<SessionCacheModel> list) {
        if (!list.isEmpty()) {
            ArrayList<String> arrayList;
            this.shouldSetLastSyncTime = true;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>();
            Iterator<SessionCacheModel> iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList2.add(iterator.next().getId());
            }
            APMSyncManagerImpl aPMSyncManagerImpl = this;
            aPMSyncManagerImpl.sessionHandler.changeSessionSyncStatus(arrayList2, 0);
            if (aPMSyncManagerImpl.apmConfigurationProvider.shouldSendLegacyAPMSessions()) {
                this.apmLogger.logSDKDebug("SDK will send APM sessions on legacy APM sessions URL");
            }
            if (this.apmConfigurationProvider.isApmSessionsRateLimited()) {
                this.handleRateIsLimited();
            } else {
                APMSyncManagerImpl aPMSyncManagerImpl2 = this;
                aPMSyncManagerImpl2.apmConfigurationProvider.setLastApmSessionsRequestStartedAt(System.currentTimeMillis());
                aPMSyncManagerImpl2.syncManagerNetworkHandler.syncSessions(list, this.callback);
            }
        } else if (this.shouldSetLastSyncTime) {
            this.apmConfigurationProvider.setLastSyncTime(System.currentTimeMillis());
        }
    }

    private void handleRateIsLimited() {
        APMSyncManagerImpl aPMSyncManagerImpl = this;
        aPMSyncManagerImpl.logRateIsLimited();
        aPMSyncManagerImpl.sessionHandler.deleteSessionsBySyncStatus(0);
        aPMSyncManagerImpl.syncNextSessionsChunk();
    }

    private void logRateIsLimited() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "APM";
        objectArray2.apmLogger.d(String.format("You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits", objectArray2));
    }

    @Nullable
    public static ComposeSpansHandler getComposeSpansHandler() {
        return ComposeSpansServiceLocator.INSTANCE.getHandler();
    }

    @Nullable
    public static ComposeSpansConfigurationProvider getComposeConfigurations() {
        return ComposeSpansServiceLocator.INSTANCE.getConfigurationProvider();
    }

    @Override
    public void start() {
        if (this.shouldSync()) {
            this.syncOldSessions();
        }
    }

    @Override
    public void start(boolean bl) {
        if (bl || this.shouldSync()) {
            this.syncOldSessions();
        }
    }

    @Override
    public boolean shouldSync() {
        if (!this.apmConfigurationProvider.shouldSendLegacyAPMSessions()) {
            return false;
        }
        return this.apmConfigurationProvider.isAPMEnabled() && this.isSyncIntervalPassed() || this.isDebugModeEnabled();
    }

    public void syncOldSessions() {
        List<SessionCacheModel> list = this.sessionHandler.getReadyToBeSentSessions();
        if (!list.isEmpty()) {
            Iterator<SessionCacheModel> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.fillSessionModel(iterator.next());
            }
            this.syncSessionsList(list);
        } else {
            this.syncNextSessionsChunk();
        }
    }
}

