/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.screenloading.di;

import android.annotation.SuppressLint;
import androidx.annotation.RequiresApi;
import com.instabug.apm.cache.handler.uitrace.UiLoadingMetricCacheHandler;
import com.instabug.apm.cache.model.UiLoadingModel;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.configuration.FeatureAvailabilityChecker;
import com.instabug.apm.di.ContextProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.sanitization.Validator;
import com.instabug.apm.screenloading.ScreenLoadingFeatureAvailabilityChecker;
import com.instabug.apm.screenloading.di.CPScreenLoadingHandlerProvider;
import com.instabug.apm.screenloading.di.EndScreenLoadingConfigurationValidatorProvider;
import com.instabug.apm.screenloading.di.MainThreadHandlerProvider;
import com.instabug.apm.screenloading.di.NativeScreenLoadingFactoryProvider;
import com.instabug.apm.screenloading.handler.CPScreenLoadingHandlerImpl;
import com.instabug.apm.screenloading.handler.NativeScreenLoadingHandlerFactory;
import com.instabug.apm.screenloading.handler.NativeScreenLoadingHandlerImpl;
import com.instabug.apm.screenloading.manager.ScreenLoadingManager;
import com.instabug.apm.screenloading.manager.ScreenLoadingManagerImpl;
import com.instabug.apm.screenloading.repo.NativeScreenLoadingRepo;
import com.instabug.apm.screenloading.repo.NativeScreenLoadingRepoFactory;
import com.instabug.apm.screenloading.validator.EndScreenLoadingConfigurationValidator;
import com.instabug.apm.screenloading.validator.NativeScreenLoadingStagesValidator;
import com.instabug.apm.uitrace.activitycallbacks.CompositeApmUiTraceActivityCallbacks;
import com.instabug.apm.uitrace.di.UiTracesServiceLocator;
import com.instabug.library.BuildFieldsProvider;
import com.instabug.library.factory.ParameterizedFactory;
import com.instabug.library.settings.SettingsManager;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00048GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0003\u001a\u0004\b\u0014\u0010\u0006R\u001c\u0010\u001b\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lcom/instabug/apm/screenloading/di/ScreenLoadingServiceLocator;", "", "<init>", "()V", "Lcom/instabug/apm/screenloading/manager/ScreenLoadingManager;", "createScreenLoadingManager", "()Lcom/instabug/apm/screenloading/manager/ScreenLoadingManager;", "Lcom/instabug/library/factory/ParameterizedFactory;", "Lcom/instabug/apm/screenloading/handler/NativeScreenLoadingHandlerImpl;", "Lcom/instabug/apm/screenloading/repo/NativeScreenLoadingRepo;", "createNativeScreenLoadingHandlerFactory", "()Lcom/instabug/library/factory/ParameterizedFactory;", "Lcom/instabug/apm/screenloading/handler/CPScreenLoadingHandlerImpl;", "createCpScreenLoadingHandler", "()Lcom/instabug/apm/screenloading/handler/CPScreenLoadingHandlerImpl;", "_screenLoadingManager", "Lcom/instabug/apm/screenloading/manager/ScreenLoadingManager;", "", "isBelowJellybean", "()Z", "getManager", "getManager$annotations", "manager", "Ljava/util/concurrent/Executor;", "kotlin.jvm.PlatformType", "getScreenLoadingSingleThreadExecutor", "()Ljava/util/concurrent/Executor;", "screenLoadingSingleThreadExecutor", "Lcom/instabug/apm/sanitization/Validator;", "", "getEndScreenLoadingConfigurationValidator", "()Lcom/instabug/apm/sanitization/Validator;", "endScreenLoadingConfigurationValidator", "Lcom/instabug/apm/cache/model/UiLoadingModel;", "getNativeScreenLoadingStagesValidator", "nativeScreenLoadingStagesValidator", "Lcom/instabug/apm/configuration/FeatureAvailabilityChecker;", "getScreenLoadingFeatureAvailabilityChecker", "()Lcom/instabug/apm/configuration/FeatureAvailabilityChecker;", "ScreenLoadingFeatureAvailabilityChecker", "instabug-apm_defaultUiRelease"}, xi=48)
@SourceDebugExtension(value={"SMAP\nScreenLoadingServiceLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenLoadingServiceLocator.kt\ncom/instabug/apm/screenloading/di/ScreenLoadingServiceLocator\n+ 2 SingletonKtx.kt\ncom/instabug/apm/di/SingletonKtxKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n9#2,4:93\n13#2,2:98\n1#3:97\n*S KotlinDebug\n*F\n+ 1 ScreenLoadingServiceLocator.kt\ncom/instabug/apm/screenloading/di/ScreenLoadingServiceLocator\n*L\n54#1:93,4\n54#1:98,2\n54#1:97\n*E\n"})
public final class ScreenLoadingServiceLocator {
    @NotNull
    public static final ScreenLoadingServiceLocator INSTANCE = new ScreenLoadingServiceLocator();
    @Nullable
    private static ScreenLoadingManager _screenLoadingManager;

    private ScreenLoadingServiceLocator() {
    }

    private final boolean isBelowJellybean() {
        return BuildFieldsProvider.INSTANCE.provideBuildVersion() < 16;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"NewApi"})
    @Nullable
    public static final ScreenLoadingManager getManager() {
        Object object = _screenLoadingManager;
        if (object != null) return object;
        object = ServiceLocator.getServiceLocatorLock();
        Intrinsics.checkNotNullExpressionValue(object, (String)"getServiceLocatorLock()");
        synchronized (object) {
            Throwable throwable2;
            block8: {
                Object object2;
                block7: {
                    try {
                        object2 = _screenLoadingManager;
                        if (object2 != null) return object2;
                    }
                    catch (Throwable throwable2) {}
                    object2 = INSTANCE;
                    if (!((ScreenLoadingServiceLocator)object2).isBelowJellybean()) break block7;
                    return null;
                }
                object2 = super.createScreenLoadingManager();
                if (object2 == null) return object2;
                _screenLoadingManager = object2;
                break block8;
                return object2;
            }
            throw throwable2;
        }
    }

    private final Executor getScreenLoadingSingleThreadExecutor() {
        return ServiceLocator.getSingleThreadExecutor("screen-loading-executor");
    }

    @RequiresApi(value=16)
    private final ScreenLoadingManager createScreenLoadingManager() {
        EndScreenLoadingConfigurationValidatorProvider endScreenLoadingConfigurationValidatorProvider;
        ContextProvider contextProvider;
        NativeScreenLoadingRepoFactory nativeScreenLoadingRepoFactory;
        CPScreenLoadingHandlerProvider cPScreenLoadingHandlerProvider;
        NativeScreenLoadingFactoryProvider nativeScreenLoadingFactoryProvider;
        ScreenLoadingServiceLocator screenLoadingServiceLocator = object;
        Object object = ServiceLocator.getApmConfigurationProvider();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApmConfigurationProvider()");
        Executor executor2 = screenLoadingServiceLocator.getScreenLoadingSingleThreadExecutor();
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"screenLoadingSingleThreadExecutor");
        object = SettingsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance()");
        NativeScreenLoadingFactoryProvider nativeScreenLoadingFactoryProvider2 = nativeScreenLoadingFactoryProvider;
        nativeScreenLoadingFactoryProvider = new NativeScreenLoadingFactoryProvider();
        CPScreenLoadingHandlerProvider cPScreenLoadingHandlerProvider2 = cPScreenLoadingHandlerProvider;
        cPScreenLoadingHandlerProvider = new CPScreenLoadingHandlerProvider();
        CompositeApmUiTraceActivityCallbacks compositeApmUiTraceActivityCallbacks = UiTracesServiceLocator.INSTANCE.getCompositeApmUiTraceActivityCallbacks();
        NativeScreenLoadingRepoFactory nativeScreenLoadingRepoFactory2 = nativeScreenLoadingRepoFactory;
        nativeScreenLoadingRepoFactory = new NativeScreenLoadingRepoFactory();
        UiLoadingMetricCacheHandler uiLoadingMetricCacheHandler = ServiceLocator.getUiLoadingMetricCacheHandler();
        Intrinsics.checkNotNullExpressionValue((Object)uiLoadingMetricCacheHandler, (String)"getUiLoadingMetricCacheHandler()");
        Logger logger2 = ServiceLocator.getApmLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getApmLogger()");
        ContextProvider contextProvider2 = contextProvider;
        contextProvider = new ContextProvider();
        EndScreenLoadingConfigurationValidatorProvider endScreenLoadingConfigurationValidatorProvider2 = endScreenLoadingConfigurationValidatorProvider;
        endScreenLoadingConfigurationValidatorProvider = new EndScreenLoadingConfigurationValidatorProvider();
        return new ScreenLoadingManagerImpl((APMConfigurationProvider)object2, executor2, (SettingsManager)object, nativeScreenLoadingFactoryProvider2, cPScreenLoadingHandlerProvider2, compositeApmUiTraceActivityCallbacks, nativeScreenLoadingRepoFactory2, uiLoadingMetricCacheHandler, logger2, contextProvider2, endScreenLoadingConfigurationValidatorProvider2);
    }

    @NotNull
    public final Validator<Unit> getEndScreenLoadingConfigurationValidator() {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        Intrinsics.checkNotNullExpressionValue((Object)aPMConfigurationProvider, (String)"getApmConfigurationProvider()");
        Logger logger2 = ServiceLocator.getApmLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getApmLogger()");
        return new EndScreenLoadingConfigurationValidator(aPMConfigurationProvider, logger2);
    }

    @NotNull
    public final Validator<UiLoadingModel> getNativeScreenLoadingStagesValidator() {
        return new NativeScreenLoadingStagesValidator();
    }

    @NotNull
    public final FeatureAvailabilityChecker getScreenLoadingFeatureAvailabilityChecker() {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        Intrinsics.checkNotNullExpressionValue((Object)aPMConfigurationProvider, (String)"getApmConfigurationProvider()");
        Logger logger2 = ServiceLocator.getApmLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getApmLogger()");
        return new ScreenLoadingFeatureAvailabilityChecker(aPMConfigurationProvider, logger2);
    }

    @NotNull
    public final ParameterizedFactory<NativeScreenLoadingHandlerImpl, NativeScreenLoadingRepo> createNativeScreenLoadingHandlerFactory() {
        MainThreadHandlerProvider mainThreadHandlerProvider;
        Executor executor2 = ((ScreenLoadingServiceLocator)((Object)executor2)).getScreenLoadingSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"screenLoadingSingleThreadExecutor");
        MainThreadHandlerProvider mainThreadHandlerProvider2 = mainThreadHandlerProvider;
        mainThreadHandlerProvider = new MainThreadHandlerProvider();
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        Intrinsics.checkNotNullExpressionValue((Object)aPMConfigurationProvider, (String)"getApmConfigurationProvider()");
        Logger logger2 = ServiceLocator.getApmLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getApmLogger()");
        return new NativeScreenLoadingHandlerFactory(executor2, mainThreadHandlerProvider2, aPMConfigurationProvider, logger2);
    }

    @NotNull
    public final CPScreenLoadingHandlerImpl createCpScreenLoadingHandler() {
        ScreenLoadingServiceLocator screenLoadingServiceLocator = aPMConfigurationProvider;
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        Intrinsics.checkNotNullExpressionValue((Object)aPMConfigurationProvider, (String)"getApmConfigurationProvider()");
        UiLoadingMetricCacheHandler uiLoadingMetricCacheHandler = ServiceLocator.getUiLoadingMetricCacheHandler();
        Intrinsics.checkNotNullExpressionValue((Object)uiLoadingMetricCacheHandler, (String)"getUiLoadingMetricCacheHandler()");
        Executor executor2 = screenLoadingServiceLocator.getScreenLoadingSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"screenLoadingSingleThreadExecutor");
        Logger logger2 = ServiceLocator.getApmLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getApmLogger()");
        return new CPScreenLoadingHandlerImpl(aPMConfigurationProvider, uiLoadingMetricCacheHandler, executor2, logger2);
    }
}

