/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networkinterception.sanitization;

import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.apm.networkinterception.map.DefaultAPMNetworkLogKtxKt;
import com.instabug.apm.sanitization.Sanitizer;
import com.instabug.library.logging.listeners.networklogs.NetworkLogListener;
import com.instabug.library.logging.listeners.networklogs.NetworkLogSnapshot;
import com.instabug.library.map.Mapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/instabug/apm/networkinterception/sanitization/UserDefinedSanitizer;", "Lcom/instabug/apm/sanitization/Sanitizer;", "Lcom/instabug/apm/model/APMNetworkLog;", "networkLogListener", "Lcom/instabug/library/logging/listeners/networklogs/NetworkLogListener;", "mapper", "Lcom/instabug/library/map/Mapper;", "Lcom/instabug/library/logging/listeners/networklogs/NetworkLogSnapshot;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "(Lcom/instabug/library/logging/listeners/networklogs/NetworkLogListener;Lcom/instabug/library/map/Mapper;Lcom/instabug/apm/logger/internal/Logger;)V", "sanitize", "item", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nUserDefinedSanitizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserDefinedSanitizer.kt\ncom/instabug/apm/networkinterception/sanitization/UserDefinedSanitizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class UserDefinedSanitizer
implements Sanitizer<APMNetworkLog> {
    @NotNull
    private final NetworkLogListener networkLogListener;
    @NotNull
    private final Mapper<APMNetworkLog, NetworkLogSnapshot> mapper;
    @NotNull
    private final Logger logger;

    public UserDefinedSanitizer(@NotNull NetworkLogListener networkLogListener, @NotNull Mapper<APMNetworkLog, NetworkLogSnapshot> mapper, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)networkLogListener, (String)"networkLogListener");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.networkLogListener = networkLogListener;
        this.mapper = mapper;
        this.logger = logger2;
    }

    @Override
    @Nullable
    public APMNetworkLog sanitize(@NotNull APMNetworkLog aPMNetworkLog) {
        Intrinsics.checkNotNullParameter((Object)aPMNetworkLog, (String)"item");
        NetworkLogSnapshot networkLogSnapshot = this.networkLogListener.onNetworkLogCaptured((NetworkLogSnapshot)this.mapper.map((Object)aPMNetworkLog));
        if (networkLogSnapshot != null) {
            if ((aPMNetworkLog = DefaultAPMNetworkLogKtxKt.applyFromSnapshot(aPMNetworkLog, networkLogSnapshot)).getUrl() == null) {
                aPMNetworkLog = null;
            }
            if (aPMNetworkLog == null) {
                this.logger.logSDKError("Removing URL property from the network request is not allowed. Please contact support for more information.");
                aPMNetworkLog = null;
            }
        } else {
            aPMNetworkLog = null;
        }
        return aPMNetworkLog;
    }
}

