/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networking.mapping.sessions;

import androidx.annotation.NonNull;
import com.instabug.apm.cache.model.FragmentSpansCacheModel;
import com.instabug.apm.cache.model.SessionCacheModel;
import com.instabug.apm.di.Provider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.networking.mapping.applaunch.AppLaunchMapper;
import com.instabug.apm.networking.mapping.experiment.ExperimentMapper;
import com.instabug.apm.networking.mapping.fragment_span.FragmentSpanMapper;
import com.instabug.apm.networking.mapping.networklog.APMNetworkLogMapper;
import com.instabug.apm.networking.mapping.sessions.SessionFeatureJsonFiller;
import com.instabug.apm.networking.mapping.sessions.SessionMapper;
import com.instabug.library.model.v3Session.IBGSessionData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class SessionMapperImpl
implements SessionMapper {
    private AppLaunchMapper appLaunchMapper = ServiceLocator.getAppLaunchMapper();
    private APMNetworkLogMapper networkLogMapper = ServiceLocator.getNetworkLogMapper();
    private ExperimentMapper experimentMapper = ServiceLocator.getExperimentMapper();
    private FragmentSpanMapper fragmentSpanMapper = ServiceLocator.getFragmentSpanMapper();
    private Provider<SessionFeatureJsonFiller[]> sessionFeatureJsonFillerProvider;

    public SessionMapperImpl(Provider<SessionFeatureJsonFiller[]> provider) {
        this.sessionFeatureJsonFillerProvider = provider;
    }

    private void fillFeatures(SessionCacheModel sessionCacheModel, JSONObject jSONObject) {
        SessionFeatureJsonFiller[] sessionFeatureJsonFillerArray = sessionFeatureJsonFillerArray.sessionFeatureJsonFillerProvider.invoke();
        int n = sessionFeatureJsonFillerArray.length;
        for (int i = 0; i < n; ++i) {
            sessionFeatureJsonFillerArray[i].addToJsonObject(sessionCacheModel, jSONObject);
        }
    }

    private void fillAppLaunch(SessionCacheModel sessionCacheModel, JSONObject jSONObject) {
        JSONArray jSONArray = null;
        if (sessionCacheModel.getAppLaunches() != null && !sessionCacheModel.getAppLaunches().isEmpty()) {
            jSONArray = sessionMapperImpl.appLaunchMapper.toJsonArray(sessionCacheModel.getAppLaunches());
        }
        if (jSONArray != null || sessionCacheModel.getSessionMetaData() != null && sessionCacheModel.getSessionMetaData().getAppLaunchesTotalCount() > 0) {
            JSONObject jSONObject2;
            SessionMapperImpl sessionMapperImpl = jSONObject2;
            jSONObject2 = new JSONObject();
            if (jSONArray != null) {
                sessionMapperImpl.put("ll", jSONArray);
            }
            SessionMapperImpl.fillDroppedAppLaunchLimits(sessionCacheModel, (JSONObject)sessionMapperImpl);
            jSONObject.put("ls", (Object)sessionMapperImpl);
        }
    }

    private static void fillDroppedAppLaunchLimits(SessionCacheModel sessionCacheModel, JSONObject jSONObject) {
        int n;
        int n2;
        if (sessionCacheModel.getSessionMetaData() != null && (n2 = sessionCacheModel.getSessionMetaData().getAppLaunchesDroppedCount()) != 0) {
            jSONObject.put("dcrl", n2);
        }
        if (sessionCacheModel.getSessionMetaData() != null && sessionCacheModel.getAppLaunches() != null && (n = sessionCacheModel.getSessionMetaData().getAppLaunchesTotalCount() - sessionCacheModel.getSessionMetaData().getAppLaunchesDroppedCount() - sessionCacheModel.getAppLaunches().size()) > 0) {
            jSONObject.put("dcsl", n);
        }
    }

    private void fillNetworkLogs(SessionCacheModel sessionCacheModel, JSONObject jSONObject) {
        JSONArray jSONArray = null;
        if (sessionCacheModel.getNetworkLogs() != null && !sessionCacheModel.getNetworkLogs().isEmpty()) {
            jSONArray = sessionMapperImpl.networkLogMapper.toJsonArray(sessionCacheModel.getNetworkLogs());
        }
        if (jSONArray != null || sessionCacheModel.getSessionMetaData() != null && sessionCacheModel.getSessionMetaData().getNetworkLogsTotalCount() > 0) {
            JSONObject jSONObject2;
            SessionMapperImpl sessionMapperImpl = jSONObject2;
            jSONObject2 = new JSONObject();
            if (jSONArray != null) {
                sessionMapperImpl.put("nl", jSONArray);
            }
            if (sessionCacheModel.getSessionMetaData() != null) {
                int n;
                int n2 = sessionCacheModel.getSessionMetaData().getNetworkLogsDroppedCount();
                if (n2 != 0) {
                    sessionMapperImpl.put("dcrl", n2);
                }
                if (sessionCacheModel.getNetworkLogs() != null && (n = sessionCacheModel.getSessionMetaData().getNetworkLogsTotalCount() - sessionCacheModel.getSessionMetaData().getNetworkLogsDroppedCount() - sessionCacheModel.getNetworkLogs().size()) != 0) {
                    sessionMapperImpl.put("dcsl", n);
                }
            }
            jSONObject.put("nts", (Object)sessionMapperImpl);
        }
    }

    private void fillExperiments(@NonNull SessionCacheModel sessionCacheModel, @NonNull JSONObject jSONObject) {
        Object object = object.experimentMapper;
        if (object != null && sessionCacheModel != null && jSONObject != null) {
            JSONObject jSONObject2 = object;
            SessionCacheModel sessionCacheModel2 = sessionCacheModel;
            object = sessionCacheModel2.getExperiments();
            if ((object = jSONObject2.toJsonObject((List<String>)object, sessionCacheModel2.getSessionMetaData())) != null) {
                jSONObject.put("exp", object);
            }
        }
    }

    private void fillFragmentSpans(@NonNull SessionCacheModel sessionCacheModel, @NonNull JSONObject jSONObject) {
        Object object = object.fragmentSpanMapper;
        if (object != null && sessionCacheModel != null && jSONObject != null) {
            JSONObject jSONObject2 = object;
            SessionCacheModel sessionCacheModel2 = sessionCacheModel;
            object = sessionCacheModel2.getFragmentSpans();
            if ((object = jSONObject2.toJsonObject((List<FragmentSpansCacheModel>)object, sessionCacheModel2.getSessionMetaData())) != null) {
                jSONObject.put("frs", object);
            }
        }
    }

    @Override
    @NonNull
    public JSONArray toJsonArray(@NonNull List<SessionCacheModel> jSONArray) {
        JSONArray jSONArray2;
        JSONArray jSONArray3 = jSONArray;
        jSONArray = jSONArray2;
        jSONArray2 = new JSONArray();
        for (SessionCacheModel sessionCacheModel : jSONArray3) {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2();
            jSONObject2.put("sid", (Object)sessionCacheModel.getCoreId());
            jSONObject2.put("os", (Object)sessionCacheModel.getOs());
            jSONObject2.put("uid", (Object)sessionCacheModel.getUuid());
            jSONObject2.put("av", (Object)sessionCacheModel.getAppVersion());
            long l = sessionCacheModel.getStartTimestampMicros();
            jSONObject2.put("st", l);
            jSONObject.put("sec", sessionCacheModel.getTerminationStatusCode());
            if (sessionCacheModel.getDuration() > 0L) {
                l = sessionCacheModel.getDuration();
                jSONObject2.put("sd", l);
            }
            SessionMapperImpl sessionMapperImpl = this;
            sessionMapperImpl.fillAppLaunch(sessionCacheModel, jSONObject2);
            sessionMapperImpl.fillNetworkLogs(sessionCacheModel, jSONObject2);
            sessionMapperImpl.fillExperiments(sessionCacheModel, jSONObject2);
            sessionMapperImpl.fillFragmentSpans(sessionCacheModel, jSONObject2);
            sessionMapperImpl.fillFeatures(sessionCacheModel, jSONObject2);
            jSONArray.put((Object)jSONObject2);
        }
        return jSONArray;
    }

    @Override
    @NonNull
    public Map<String, IBGSessionData> toSessionData(@NonNull List<SessionCacheModel> object) {
        HashMap hashMap;
        List<SessionCacheModel> list = object;
        object = hashMap;
        hashMap = new HashMap();
        Iterator<SessionCacheModel> iterator = list.iterator();
        while (iterator.hasNext()) {
            IBGSessionData iBGSessionData;
            JSONObject jSONObject;
            SessionMapperImpl sessionMapperImpl = this;
            SessionCacheModel sessionCacheModel = iterator.next();
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject();
            sessionMapperImpl.fillAppLaunch(sessionCacheModel, jSONObject2);
            sessionMapperImpl.fillNetworkLogs(sessionCacheModel, jSONObject2);
            sessionMapperImpl.fillFragmentSpans(sessionCacheModel, jSONObject2);
            sessionMapperImpl.fillFeatures(sessionCacheModel, jSONObject2);
            if (!jSONObject2.keys().hasNext()) continue;
            SessionCacheModel sessionCacheModel2 = sessionCacheModel;
            sessionCacheModel = iBGSessionData;
            iBGSessionData = new IBGSessionData("ad", jSONObject2);
            object.put(sessionCacheModel2.getCoreId(), sessionCacheModel);
        }
        return object;
    }
}

