/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.handler.applaunch;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.apm.cache.handler.applaunch.AppLaunchCacheHandler;
import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandler;
import com.instabug.apm.cache.model.AppLaunchCacheModel;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.applaunch.AppLaunchesHandler;
import java.util.List;

@WorkerThread
public class AppLaunchesHandlerImpl
implements AppLaunchesHandler {
    private final AppLaunchCacheHandler appLaunchCacheHandler = ServiceLocator.getAppLaunchCacheHandler();
    @Nullable
    private final SessionMetaDataCacheHandler sessionMetaDataCacheHandler = ServiceLocator.getSessionMetaDataCacheHandler();
    private final APMConfigurationProvider configurationProvider = ServiceLocator.getApmConfigurationProvider();

    private void trimAppLaunch(String string, AppLaunchCacheModel object, long l) {
        object = ((AppLaunchCacheModel)object).getType();
        if (l != -1L && object != null) {
            AppLaunchesHandlerImpl appLaunchesHandlerImpl = this;
            appLaunchesHandlerImpl.trimLaunchToLimitPerRequest(string, (String)object);
            appLaunchesHandlerImpl.trimAppLaunchesToLimit(appLaunchesHandlerImpl.configurationProvider.getAppLaunchStoreLimit((String)object), (String)object);
        }
    }

    private void trimLaunchToLimitPerRequest(String string, String string2) {
        if (this.sessionMetaDataCacheHandler == null) {
            return;
        }
        int n = this.trimAppLaunchesToLimit(string, this.configurationProvider.getAppLaunchRequestLimit(string2), string2);
        if (n > 0) {
            this.sessionMetaDataCacheHandler.addToAppLaunchesDroppedCount(string, n);
        }
    }

    private int trimAppLaunchesToLimit(String string, long l, String string2) {
        return this.appLaunchCacheHandler.trimAppLaunchesToLimit(string, l, string2);
    }

    private void trimAppLaunchesToLimit(long l, String string) {
        this.appLaunchCacheHandler.trimAppLaunchesToLimit(l, string);
    }

    private void clearCounts() {
        SessionMetaDataCacheHandler sessionMetaDataCacheHandler = ((AppLaunchesHandlerImpl)((Object)sessionMetaDataCacheHandler)).sessionMetaDataCacheHandler;
        if (sessionMetaDataCacheHandler != null) {
            sessionMetaDataCacheHandler.resetAppLaunchesCounts();
        }
    }

    @Override
    public long insertAppLaunch(String string, AppLaunchCacheModel appLaunchCacheModel) {
        AppLaunchesHandlerImpl appLaunchesHandlerImpl = this;
        long l = appLaunchesHandlerImpl.appLaunchCacheHandler.insertAppLaunch(string, appLaunchCacheModel);
        SessionMetaDataCacheHandler sessionMetaDataCacheHandler = appLaunchesHandlerImpl.sessionMetaDataCacheHandler;
        if (sessionMetaDataCacheHandler != null && l != -1L) {
            sessionMetaDataCacheHandler.addToAppLaunchesTotalCount(string, 1);
        }
        this.trimAppLaunch(string, appLaunchCacheModel, l);
        return l;
    }

    @Override
    @Nullable
    public List<AppLaunchCacheModel> getAppLaunchesForSession(String string) {
        return this.appLaunchCacheHandler.getAppLaunchesForSession(string);
    }

    @Override
    public void removeAppLaunches(@NonNull String string, boolean bl) {
        this.appLaunchCacheHandler.removeAppLaunches(string);
        if (bl) {
            this.clearCounts();
        }
    }

    @Override
    public void removeAll() {
        AppLaunchesHandlerImpl appLaunchesHandlerImpl = this;
        appLaunchesHandlerImpl.appLaunchCacheHandler.removeAll();
        appLaunchesHandlerImpl.clearCounts();
    }

    @Override
    public void updateAppLaunch(AppLaunchCacheModel appLaunchCacheModel) {
        this.appLaunchCacheHandler.updateAppLaunch(appLaunchCacheModel);
    }
}

