/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.compose.compose_spans;

import com.instabug.apm.compose.compose_spans.ComposeSpansEventsRepository;
import com.instabug.apm.compose.compose_spans.configuration.ComposeSpansConfigurationProvider;
import com.instabug.apm.compose.compose_spans.handler.ComposeSpansHandler;
import com.instabug.apm.compose.compose_spans.model.ComposeSpanEvent;
import com.instabug.apm.compose.compose_spans.model.ComposeSpansCacheModel;
import com.instabug.apm.compose.compose_spans.model.ComposeSpansModel;
import com.instabug.apm.handler.session.SessionHandler;
import com.instabug.library.map.Mapper;
import com.instabug.library.util.collections.LimitedLinkedHashmap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0007\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0006\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u0013*\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\n*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010#R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010$R\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010%R\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010%R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010&R,\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070'8\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b(\u0010)\u0012\u0004\b,\u0010-\u001a\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lcom/instabug/apm/compose/compose_spans/ComposeSpansEventsRepositoryImpl;", "Lcom/instabug/apm/compose/compose_spans/ComposeSpansEventsRepository;", "Lcom/instabug/apm/compose/compose_spans/handler/ComposeSpansHandler;", "handler", "Lcom/instabug/apm/handler/session/SessionHandler;", "sessionHandler", "Lcom/instabug/library/map/Mapper;", "Lcom/instabug/apm/compose/compose_spans/model/ComposeSpansModel;", "Lcom/instabug/apm/compose/compose_spans/model/ComposeSpansCacheModel;", "mapper", "", "nameSanitizer", "Lcom/instabug/apm/compose/compose_spans/configuration/ComposeSpansConfigurationProvider;", "configurationProvider", "<init>", "(Lcom/instabug/apm/compose/compose_spans/handler/ComposeSpansHandler;Lcom/instabug/apm/handler/session/SessionHandler;Lcom/instabug/library/map/Mapper;Lcom/instabug/library/map/Mapper;Lcom/instabug/apm/compose/compose_spans/configuration/ComposeSpansConfigurationProvider;)V", "key", "Lcom/instabug/apm/compose/compose_spans/model/ComposeSpanEvent$CompositionStarted;", "event", "", "createNewModel", "(Ljava/lang/String;Lcom/instabug/apm/compose/compose_spans/model/ComposeSpanEvent$CompositionStarted;)V", "removeModelFromMemory", "(Ljava/lang/String;)Lcom/instabug/apm/compose/compose_spans/model/ComposeSpansModel;", "saveModelToDiskAndDeleteItFromMemory", "(Ljava/lang/String;)V", "Lcom/instabug/apm/compose/compose_spans/model/ComposeSpanEvent;", "addEventToMemory", "(Ljava/lang/String;Lcom/instabug/apm/compose/compose_spans/model/ComposeSpanEvent;)V", "saveToDisk", "(Lcom/instabug/apm/compose/compose_spans/model/ComposeSpansModel;)V", "getKey", "(Lcom/instabug/apm/compose/compose_spans/model/ComposeSpanEvent;)Ljava/lang/String;", "addEvent", "(Lcom/instabug/apm/compose/compose_spans/model/ComposeSpanEvent;)V", "Lcom/instabug/apm/compose/compose_spans/handler/ComposeSpansHandler;", "Lcom/instabug/apm/handler/session/SessionHandler;", "Lcom/instabug/library/map/Mapper;", "Lcom/instabug/apm/compose/compose_spans/configuration/ComposeSpansConfigurationProvider;", "", "eventsMap", "Ljava/util/Map;", "getEventsMap", "()Ljava/util/Map;", "getEventsMap$annotations", "()V", "instabug-apm_defaultUiRelease"}, xi=48)
public final class ComposeSpansEventsRepositoryImpl
implements ComposeSpansEventsRepository {
    @NotNull
    private final ComposeSpansHandler handler;
    @NotNull
    private final SessionHandler sessionHandler;
    @NotNull
    private final Mapper<ComposeSpansModel, ComposeSpansCacheModel> mapper;
    @NotNull
    private final Mapper<String, String> nameSanitizer;
    @NotNull
    private final ComposeSpansConfigurationProvider configurationProvider;
    @NotNull
    private final Map<String, ComposeSpansModel> eventsMap;

    public ComposeSpansEventsRepositoryImpl(@NotNull ComposeSpansHandler composeSpansHandler, @NotNull SessionHandler sessionHandler, @NotNull Mapper<ComposeSpansModel, ComposeSpansCacheModel> mapper, @NotNull Mapper<String, String> mapper2, @NotNull ComposeSpansConfigurationProvider composeSpansConfigurationProvider) {
        LimitedLinkedHashmap limitedLinkedHashmap;
        Intrinsics.checkNotNullParameter((Object)composeSpansHandler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)sessionHandler, (String)"sessionHandler");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(mapper2, (String)"nameSanitizer");
        Intrinsics.checkNotNullParameter((Object)composeSpansConfigurationProvider, (String)"configurationProvider");
        composeSpansEventsRepositoryImpl.handler = composeSpansHandler;
        composeSpansEventsRepositoryImpl.sessionHandler = sessionHandler;
        composeSpansEventsRepositoryImpl.mapper = mapper;
        composeSpansEventsRepositoryImpl.nameSanitizer = mapper2;
        composeSpansEventsRepositoryImpl.configurationProvider = composeSpansConfigurationProvider;
        ComposeSpansEventsRepositoryImpl composeSpansEventsRepositoryImpl = limitedLinkedHashmap;
        limitedLinkedHashmap = new LimitedLinkedHashmap(50);
        v1.eventsMap = composeSpansEventsRepositoryImpl;
    }

    private final void createNewModel(String string, ComposeSpanEvent.CompositionStarted compositionStarted) {
        String string2 = (String)this.nameSanitizer.map((Object)compositionStarted.getComposableName());
        if (string2 != null) {
            Map<String, ComposeSpansModel> map = this.eventsMap;
            boolean bl = compositionStarted.getShowAsScreen() && this.configurationProvider.getScreenLoadingSegmentationEnabled();
            long l = compositionStarted.getTimeCapture().getTimeStampMicro();
            ComposeSpansModel composeSpansModel = new ComposeSpansModel(string2, bl, l);
            map.put(string, composeSpansModel);
        }
    }

    private final ComposeSpansModel removeModelFromMemory(String string) {
        return this.eventsMap.remove(string);
    }

    private final void saveModelToDiskAndDeleteItFromMemory(String object) {
        if ((object = this.removeModelFromMemory((String)object)) != null) {
            this.saveToDisk((ComposeSpansModel)object);
        }
    }

    private final void addEventToMemory(String string, ComposeSpanEvent composeSpanEvent) {
        ComposeSpansModel composeSpansModel = ((ComposeSpansEventsRepositoryImpl)((Object)composeSpansModel)).eventsMap.get(string);
        if (composeSpansModel != null) {
            ComposeSpanEvent composeSpanEvent2 = composeSpanEvent;
            int n = composeSpanEvent2.getEventId();
            composeSpansModel.set(n, composeSpanEvent2.getTimeCapture());
        }
    }

    private final void saveToDisk(ComposeSpansModel object) {
        if ((object = (ComposeSpansCacheModel)((ComposeSpansEventsRepositoryImpl)((Object)composeSpansHandler)).mapper.map(object)) != null) {
            ComposeSpansEventsRepositoryImpl composeSpansEventsRepositoryImpl = composeSpansHandler;
            ComposeSpansHandler composeSpansHandler = composeSpansEventsRepositoryImpl.handler;
            Object object2 = composeSpansEventsRepositoryImpl.sessionHandler.getCurrentSession();
            object2 = object2 != null ? object2.getId() : null;
            composeSpansHandler.save((ComposeSpansCacheModel)object, (String)object2);
        }
    }

    private final String getKey(ComposeSpanEvent composeSpanEvent) {
        return "" + composeSpanEvent.getId() + '-' + composeSpanEvent.getComposableName();
    }

    @Override
    public void addEvent(@NotNull ComposeSpanEvent composeSpanEvent) {
        ComposeSpanEvent composeSpanEvent2 = composeSpanEvent;
        Intrinsics.checkNotNullParameter((Object)composeSpanEvent2, (String)"event");
        String string = this.getKey(composeSpanEvent2);
        if (composeSpanEvent instanceof ComposeSpanEvent.CompositionStarted) {
            ComposeSpansEventsRepositoryImpl composeSpansEventsRepositoryImpl = this;
            this.saveModelToDiskAndDeleteItFromMemory(string);
            composeSpansEventsRepositoryImpl.createNewModel(string, (ComposeSpanEvent.CompositionStarted)composeSpanEvent);
            composeSpansEventsRepositoryImpl.addEventToMemory(string, composeSpanEvent);
        } else if (composeSpanEvent instanceof ComposeSpanEvent.RenderingEnded) {
            ComposeSpansEventsRepositoryImpl composeSpansEventsRepositoryImpl = this;
            composeSpansEventsRepositoryImpl.addEventToMemory(string, composeSpanEvent);
            composeSpansEventsRepositoryImpl.saveModelToDiskAndDeleteItFromMemory(string);
        } else if (composeSpanEvent instanceof ComposeSpanEvent.Dispose) {
            this.saveModelToDiskAndDeleteItFromMemory(string);
        } else {
            this.addEventToMemory(string, composeSpanEvent);
        }
    }
}

