/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.common.concurrent;

import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.diagnostics.IBGDiagnostics;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=2, d1={"\u0000\u001a\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a#\u0010\b\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\t\"\u0014\u0010\f\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"", "throwable", "", "checkAndReportError", "(Ljava/lang/Throwable;)V", "Lcom/instabug/apm/logger/internal/Logger;", "", "message", "reportAndLogError", "(Lcom/instabug/apm/logger/internal/Logger;Ljava/lang/String;Ljava/lang/Throwable;)V", "getSharedOrderedExecutorErrorMessage", "()Ljava/lang/String;", "sharedOrderedExecutorErrorMessage", "instabug-apm_defaultUiRelease"}, xi=48)
@SourceDebugExtension(value={"SMAP\nOrderedExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderedExecutor.kt\ncom/instabug/apm/common/concurrent/OrderedExecutorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n29#1:62\n1#2:61\n*S KotlinDebug\n*F\n+ 1 OrderedExecutor.kt\ncom/instabug/apm/common/concurrent/OrderedExecutorKt\n*L\n32#1:62\n*E\n"})
public abstract class OrderedExecutorKt {
    private static final String getSharedOrderedExecutorErrorMessage() {
        return "ordered executor(" + Thread.currentThread().getName() + ')';
    }

    private static final void checkAndReportError(Throwable throwable) {
        Logger logger2 = ServiceLocator.getApmLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getApmLogger()");
        if (throwable instanceof InterruptedException) {
            logger2.logSDKProtected(OrderedExecutorKt.getSharedOrderedExecutorErrorMessage() + " has been interrupted");
        } else if (throwable instanceof ExecutionException) {
            OrderedExecutorKt.reportAndLogError(logger2, OrderedExecutorKt.getSharedOrderedExecutorErrorMessage() + " encountered execution error: " + throwable.getMessage(), throwable);
        } else if (throwable instanceof OutOfMemoryError) {
            OrderedExecutorKt.reportAndLogError(logger2, OrderedExecutorKt.getSharedOrderedExecutorErrorMessage() + " encountered an OOM error", throwable);
        } else {
            OrderedExecutorKt.reportAndLogError(logger2, OrderedExecutorKt.getSharedOrderedExecutorErrorMessage() + " encountered an error " + throwable.getMessage(), throwable);
        }
    }

    private static final void reportAndLogError(Logger logger2, String string, Throwable throwable) {
        logger2.logSDKErrorWithStackTrace(string, throwable);
        IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)string);
    }

    public static final /* synthetic */ void access$checkAndReportError(Throwable throwable) {
        OrderedExecutorKt.checkAndReportError(throwable);
    }
}

