/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.handler.uitrace;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.cache.handler.uitrace.UiLoadingMetricCacheHandler;
import com.instabug.apm.cache.handler.uitrace.UiTraceCacheHandler;
import com.instabug.apm.cache.model.UiLoadingModel;
import com.instabug.apm.cache.model.UiTraceCacheModel;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.webview.webview_trace.model.WebViewCacheModel;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import java.util.List;

public class UiTraceCacheHandlerImpl
implements UiTraceCacheHandler {
    @Nullable
    private DatabaseManager databaseManager = ServiceLocator.getDatabaseManager();
    private Logger apmLogger = ServiceLocator.getApmLogger();
    private UiLoadingMetricCacheHandler uiLoadingMetricCacheHandler = ServiceLocator.getUiLoadingMetricCacheHandler();

    private static void putIdToContentValuesIfPossible(UiTraceCacheModel uiTraceCacheModel, ContentValues contentValues) {
        if (uiTraceCacheModel.getId() > 0L) {
            contentValues.put("id", Long.valueOf(uiTraceCacheModel.getId()));
        }
    }

    private ContentValues getContentValues(UiTraceCacheModel uiTraceCacheModel) {
        ContentValues contentValues;
        UiTraceCacheHandlerImpl uiTraceCacheHandlerImpl = contentValues;
        contentValues = new ContentValues();
        if (uiTraceCacheModel.getName() != null) {
            uiTraceCacheHandlerImpl.put("trace_name", uiTraceCacheModel.getName());
        }
        if (uiTraceCacheModel.getSessionId() != null) {
            uiTraceCacheHandlerImpl.put("session_id", uiTraceCacheModel.getSessionId());
        }
        UiTraceCacheHandlerImpl uiTraceCacheHandlerImpl2 = uiTraceCacheHandlerImpl;
        uiTraceCacheHandlerImpl2.put("duration", uiTraceCacheModel.getDuration());
        uiTraceCacheHandlerImpl2.put("small_drops_duration", uiTraceCacheModel.getSmallDropsDuration());
        uiTraceCacheHandlerImpl2.put("large_drop_duration", uiTraceCacheModel.getLargeDropsDuration());
        uiTraceCacheHandlerImpl2.put("batter_level", uiTraceCacheModel.getBatteryLevel());
        uiTraceCacheHandlerImpl2.put("user_defined", uiTraceCacheModel.isUserDefined());
        uiTraceCacheHandlerImpl2.put("display_refresh_rate", uiTraceCacheModel.getRefreshRate());
        uiTraceCacheHandlerImpl2.put("start_time", uiTraceCacheModel.getStartTimestamp());
        if (uiTraceCacheModel.getScreenTitle() != null) {
            uiTraceCacheHandlerImpl.put("screen_title", uiTraceCacheModel.getScreenTitle());
        }
        if (uiTraceCacheModel.getPowerSaveMode() != null) {
            uiTraceCacheHandlerImpl.put("power_save_more_enabled", uiTraceCacheModel.getPowerSaveMode());
        }
        if (uiTraceCacheModel.getContainerName() != null) {
            uiTraceCacheHandlerImpl.put("container_name", uiTraceCacheModel.getContainerName());
        }
        if (uiTraceCacheModel.getModuleName() != null) {
            uiTraceCacheHandlerImpl.put("module_name", uiTraceCacheModel.getModuleName());
        }
        if (uiTraceCacheModel.getOrientation() != null) {
            uiTraceCacheHandlerImpl.put("orientation", uiTraceCacheModel.getOrientation());
        }
        return uiTraceCacheHandlerImpl;
    }

    private UiTraceCacheModel readFromCursor(Cursor cursor) {
        UiTraceCacheModel uiTraceCacheModel;
        UiTraceCacheModel uiTraceCacheModel2 = uiTraceCacheModel;
        new UiTraceCacheModel().setId(cursor.getLong(cursor.getColumnIndexOrThrow("id")));
        uiTraceCacheModel2.setName(cursor.getString(cursor.getColumnIndexOrThrow("trace_name")));
        uiTraceCacheModel2.setScreenTitle(cursor.getString(cursor.getColumnIndexOrThrow("screen_title")));
        uiTraceCacheModel2.setDuration(cursor.getLong(cursor.getColumnIndexOrThrow("duration")));
        uiTraceCacheModel2.setSmallDropsDuration(cursor.getLong(cursor.getColumnIndexOrThrow("small_drops_duration")));
        uiTraceCacheModel2.setLargeDropsDuration(cursor.getLong(cursor.getColumnIndexOrThrow("large_drop_duration")));
        uiTraceCacheModel2.setBatteryLevel(cursor.getInt(cursor.getColumnIndexOrThrow("batter_level")));
        Boolean bl = cursor.getInt(cursor.getColumnIndexOrThrow("power_save_more_enabled")) == 1;
        UiTraceCacheModel uiTraceCacheModel3 = uiTraceCacheModel2;
        uiTraceCacheModel3.setPowerSaveMode(bl);
        uiTraceCacheModel3.setRefreshRate(cursor.getInt(cursor.getColumnIndexOrThrow("display_refresh_rate")));
        uiTraceCacheModel3.setStartTimestamp(cursor.getLong(cursor.getColumnIndexOrThrow("start_time")));
        uiTraceCacheModel3.setContainerName(cursor.getString(cursor.getColumnIndexOrThrow("container_name")));
        uiTraceCacheModel3.setModuleName(cursor.getString(cursor.getColumnIndexOrThrow("module_name")));
        uiTraceCacheModel3.setOrientation(cursor.getString(cursor.getColumnIndexOrThrow("orientation")));
        boolean bl2 = cursor.getInt(cursor.getColumnIndexOrThrow("user_defined")) == 1;
        Object object = uiTraceCacheModel2;
        ((UiTraceCacheModel)object).setUserDefined(bl2);
        return object;
    }

    private void fillUiTraceMetrics(@Nullable List<UiTraceCacheModel> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            UiTraceCacheModel uiTraceCacheModel = (UiTraceCacheModel)object.next();
            if (uiTraceCacheModel == null) continue;
            UiTraceCacheHandlerImpl uiTraceCacheHandlerImpl = this;
            uiTraceCacheHandlerImpl.addUiLoadingModelToUiTraces(uiTraceCacheModel);
            uiTraceCacheHandlerImpl.addWebViewCacheModelToUiTraces(uiTraceCacheModel);
        }
    }

    private void addUiLoadingModelToUiTraces(@NonNull UiTraceCacheModel uiTraceCacheModel) {
        UiLoadingModel uiLoadingModel = ((UiTraceCacheHandlerImpl)((Object)uiLoadingModel)).uiLoadingMetricCacheHandler.getUiLoadingMetricForUiTrace(uiTraceCacheModel.getId());
        if (uiLoadingModel != null) {
            uiTraceCacheModel.setUiLoadingModel(uiLoadingModel);
        }
    }

    private void addWebViewCacheModelToUiTraces(@NonNull UiTraceCacheModel uiTraceCacheModel) {
        Object object = ServiceLocator.getWebViewTraceCacheHandler();
        if (object == null) {
            return;
        }
        if ((object = object.retrieve(uiTraceCacheModel.getId())) != null) {
            uiTraceCacheModel.setWebViewTraces((List<WebViewCacheModel>)object);
        }
    }

    private void removeInvalidUiTraces() {
        if ((this = this.getDatabaseManager()) != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.openDatabase();
            sQLiteDatabaseWrapper.execSQL("DELETE FROM apm_ui_traces WHERE (small_drops_duration = -1 OR large_drop_duration = -1) AND id NOT IN (SELECT ui_trace_id FROM apm_ui_loading ) ");
            sQLiteDatabaseWrapper.close();
        }
    }

    @Nullable
    private DatabaseManager getDatabaseManager() {
        if (this.databaseManager == null) {
            this.databaseManager = ServiceLocator.getDatabaseManager();
        }
        return this.databaseManager;
    }

    @Override
    public long insert(UiTraceCacheModel uiTraceCacheModel) {
        if (uiTraceCacheModel == null) {
            return -1L;
        }
        DatabaseManager databaseManager = uiTraceCacheHandlerImpl.getDatabaseManager();
        if (databaseManager != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = databaseManager.openDatabase();
            UiTraceCacheHandlerImpl uiTraceCacheHandlerImpl = uiTraceCacheHandlerImpl.getContentValues(uiTraceCacheModel);
            UiTraceCacheHandlerImpl.putIdToContentValuesIfPossible(uiTraceCacheModel, (ContentValues)uiTraceCacheHandlerImpl);
            return sQLiteDatabaseWrapper.insertWithOnConflict("apm_ui_traces", null, (ContentValues)uiTraceCacheHandlerImpl);
        }
        return -1L;
    }

    @Override
    public int update(@Nullable UiTraceCacheModel stringArray) {
        DatabaseManager databaseManager = ((UiTraceCacheHandlerImpl)((Object)string)).getDatabaseManager();
        if (stringArray != null && databaseManager != null) {
            ContentValues contentValues = ((UiTraceCacheHandlerImpl)((Object)string)).getContentValues((UiTraceCacheModel)stringArray);
            String string = "" + stringArray.getId();
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
            return databaseManager.openDatabase().update("apm_ui_traces", contentValues, "id = ?", stringArray);
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void trimToLimit(long l) {
        Throwable throwable2222222;
        String string;
        block4: {
            String[] stringArray = this.getDatabaseManager();
            if (stringArray == null) return;
            String[] stringArray2 = stringArray;
            String string2 = "id NOT IN (" + " SELECT id FROM apm_ui_traces ORDER BY id DESC LIMIT ?" + ")";
            string = String.valueOf(l);
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = string;
            string = stringArray2.openDatabase();
            string.delete("apm_ui_traces", string2, stringArray);
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (Exception exception) {}
                {
                    this.apmLogger.logSDKError("DB execution a sql failed: " + exception.getMessage(), exception);
                    IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("DB execution a sql failed: " + exception.getMessage()));
                    if (string == null) return;
                }
                string.close();
                return;
            }
            string.close();
            return;
        }
        if (string == null) throw throwable2222222;
        string.close();
        throw throwable2222222;
    }

    @Override
    public int trimToLimit(String string, long l) {
        if ((object = ((UiTraceCacheHandlerImpl)object).getDatabaseManager()) != null) {
            UiTraceCacheHandlerImpl uiTraceCacheHandlerImpl = object;
            Object object = "session_id = ? AND duration > 0 AND id NOT IN (" + "SELECT id FROM apm_ui_traces where session_id = ? AND duration > 0  ORDER BY id DESC LIMIT ?" + " ) ";
            String string2 = String.valueOf(l);
            String[] stringArray = new String[3];
            String[] stringArray2 = stringArray;
            stringArray[0] = string;
            stringArray[1] = string;
            stringArray[2] = string2;
            string = uiTraceCacheHandlerImpl.openDatabase();
            int n = string.delete("apm_ui_traces", (String)object, stringArray2);
            string.close();
            return n;
        }
        return -1;
    }

    @Override
    public int clearPreviousUnEndedTraces(String string) {
        if ((stringArray3 = stringArray3.getDatabaseManager()) == null) {
            return 0;
        }
        String[] stringArray = stringArray3;
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = string;
        return stringArray.openDatabase().delete("apm_ui_traces", "session_id != ? AND duration = 0 ", stringArray3);
    }

    @Override
    public void removeAll() {
        if ((this = this.getDatabaseManager()) != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.openDatabase();
            sQLiteDatabaseWrapper.execSQL("DELETE FROM apm_ui_traces");
            sQLiteDatabaseWrapper.close();
        }
    }

    @Override
    public void removeUiHangs() {
        DatabaseManager databaseManager = this.getDatabaseManager();
        if (databaseManager != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = databaseManager.openDatabase();
            sQLiteDatabaseWrapper.execSQL("UPDATE apm_ui_traces SET small_drops_duration = -1, large_drop_duration = -1");
            sQLiteDatabaseWrapper.close();
            this.removeInvalidUiTraces();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public List<UiTraceCacheModel> getUiTracesForSession(@NonNull String var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [7, 6 : 105->110)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

