/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.handler.executiontraces;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.cache.handler.executiontraces.DanglingExecutionTracesCacheHandler;
import com.instabug.apm.cache.handler.executiontraces.ExecutionTracesCacheHandler;
import com.instabug.apm.cache.handler.executiontraces.ExecutionTracesMigrationHandler;
import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandler;
import com.instabug.apm.cache.model.ExecutionTraceCacheModel;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.library.model.common.Session;
import java.util.List;
import java.util.concurrent.Executor;

public class ExecutionTracesMigrationHandlerImpl
implements ExecutionTracesMigrationHandler {
    @NonNull
    private final ExecutionTracesCacheHandler cacheHandler;
    @NonNull
    private final DanglingExecutionTracesCacheHandler danglingCacheHandler;
    @NonNull
    private final APMConfigurationProvider configurationProvider;
    @Nullable
    private final SessionMetaDataCacheHandler sessionMetaDataCacheHandler;

    public ExecutionTracesMigrationHandlerImpl(@NonNull ExecutionTracesCacheHandler executionTracesCacheHandler, @NonNull DanglingExecutionTracesCacheHandler danglingExecutionTracesCacheHandler, @NonNull APMConfigurationProvider aPMConfigurationProvider, @NonNull Executor executor2, @Nullable SessionMetaDataCacheHandler sessionMetaDataCacheHandler) {
        this.cacheHandler = executionTracesCacheHandler;
        this.danglingCacheHandler = danglingExecutionTracesCacheHandler;
        this.configurationProvider = aPMConfigurationProvider;
        this.sessionMetaDataCacheHandler = sessionMetaDataCacheHandler;
    }

    @Override
    public void migrate(@NonNull Session session, @NonNull Session session2) {
        List<ExecutionTraceCacheModel> list;
        long l = this.configurationProvider.getExecutionTraceLimitPerRequest();
        do {
            if ((list = this.getBatch(l)) == null) continue;
            for (ExecutionTraceCacheModel executionTraceCacheModel : list) {
                if (this.shouldLinkToLastSession(executionTraceCacheModel)) {
                    this.migrate(executionTraceCacheModel, session2);
                    continue;
                }
                this.migrate(executionTraceCacheModel, session);
            }
            this.deleteBatch(list);
        } while (list != null && list.size() > 0);
    }

    @VisibleForTesting
    @Nullable
    List<ExecutionTraceCacheModel> getBatch(long l) {
        return this.danglingCacheHandler.getEndedTraces(l);
    }

    @VisibleForTesting
    void migrate(@NonNull ExecutionTraceCacheModel executionTraceCacheModel, @NonNull Session session) {
        if (this.sessionMetaDataCacheHandler != null) {
            ExecutionTracesMigrationHandlerImpl executionTracesMigrationHandlerImpl = this;
            executionTracesMigrationHandlerImpl.cacheHandler.insertTrace(session.getId(), executionTraceCacheModel);
            executionTracesMigrationHandlerImpl.sessionMetaDataCacheHandler.addToTracesTotalCount(session.getId(), 1);
        }
    }

    @VisibleForTesting
    void deleteBatch(@NonNull List<ExecutionTraceCacheModel> list) {
        this.danglingCacheHandler.removeEndedTraces(list.size());
    }

    @VisibleForTesting
    boolean shouldLinkToLastSession(@NonNull ExecutionTraceCacheModel executionTraceCacheModel) {
        return !executionTraceCacheModel.startedInBackground() && executionTraceCacheModel.endedInBackground() || !executionTraceCacheModel.startedInBackground() && !executionTraceCacheModel.endedInBackground();
    }
}

