/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.appflow.validate;

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider;
import com.instabug.apm.appflow.log.LoggerExtKt;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.sanitization.Validator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u00038\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u00058\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\b\u001a\u00020\u00078\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\n\u001a\u00020\t8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/instabug/apm/appflow/validate/ConfigurationsValidator;", "Lcom/instabug/apm/sanitization/Validator;", "", "", "apiName", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "apmConfigurations", "Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;", "appFLowConfigurations", "Lcom/instabug/apm/logger/internal/Logger;", "logger", "<init>", "(Ljava/lang/String;Lcom/instabug/apm/configuration/APMConfigurationProvider;Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;Lcom/instabug/apm/logger/internal/Logger;)V", "item", "", "isValid", "(Lkotlin/Unit;)Z", "Ljava/lang/String;", "getApiName", "()Ljava/lang/String;", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "getApmConfigurations", "()Lcom/instabug/apm/configuration/APMConfigurationProvider;", "Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;", "getAppFLowConfigurations", "()Lcom/instabug/apm/appflow/configuration/AppFlowConfigurationProvider;", "Lcom/instabug/apm/logger/internal/Logger;", "getLogger", "()Lcom/instabug/apm/logger/internal/Logger;", "instabug-apm_defaultUiRelease"}, xi=48)
public class ConfigurationsValidator
implements Validator<Unit> {
    @NotNull
    private final String apiName;
    @NotNull
    private final APMConfigurationProvider apmConfigurations;
    @NotNull
    private final AppFlowConfigurationProvider appFLowConfigurations;
    @NotNull
    private final Logger logger;

    public ConfigurationsValidator(@NotNull String string, @NotNull APMConfigurationProvider aPMConfigurationProvider, @NotNull AppFlowConfigurationProvider appFlowConfigurationProvider, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"apiName");
        Intrinsics.checkNotNullParameter((Object)aPMConfigurationProvider, (String)"apmConfigurations");
        Intrinsics.checkNotNullParameter((Object)appFlowConfigurationProvider, (String)"appFLowConfigurations");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.apiName = string;
        this.apmConfigurations = aPMConfigurationProvider;
        this.appFLowConfigurations = appFlowConfigurationProvider;
        this.logger = logger2;
    }

    @NotNull
    protected final String getApiName() {
        return this.apiName;
    }

    @NotNull
    protected final AppFlowConfigurationProvider getAppFLowConfigurations() {
        return this.appFLowConfigurations;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isValid(@NotNull Unit unit) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"item");
        if (!this.apmConfigurations.isAPMSdkEnabled()) {
            LoggerExtKt.logAPMSdkDisabled(this.logger, this.apiName);
            bl = false;
        } else if (this.apmConfigurations.isAPMFeatureAvailable() && this.appFLowConfigurations.getFeatureEnabled()) {
            bl = true;
        } else {
            LoggerExtKt.logFeatureBEDisabled(this.logger, this.apiName);
            bl = false;
        }
        return bl;
    }
}

