package com.instabug.apm.webview.webview_trace.util

import android.util.DisplayMetrics
import com.instabug.apm.di.Provider
import com.instabug.apm.util.rectangleDiagonalPercentage
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider
import com.instabug.library.diagnostics.IBGDiagnostics

class WebViewSizeEventResolver(
    private val screenDisplayMetricProvider: Provider<DisplayMetrics>,
    private val configurations: WebViewTraceConfigurationProvider
) {

    fun isFullScreen(widthPx: Int, heightPx: Int): Boolean? =
        try {
            val percentage = rectangleDiagonalPercentage(
                widthPx.toDouble(),
                heightPx.toDouble(),
                screenDisplayMetricProvider.invoke()
            )
            percentage > configurations.partialViewPercentage
        } catch (exception: Exception) {
            IBGDiagnostics.reportNonFatal(
                exception,
                "failed to resolve WebView size category"
            )
            null
        }
}