package com.instabug.apm.webview.webview_trace.model.event

import com.instabug.apm.model.EventTimeMetricCapture

class WebViewVitalEvent : WebViewEvent {

    val name: String
    val value: Double

    constructor(
        name: String,
        value: Double,
        timeCapture: EventTimeMetricCapture = EventTimeMetricCapture(),
        copyCount: Int = 0
    ) : super(
        id = WebViewEventId.WEB_VITAL,
        timeCapture = timeCapture,
        isTermination = false,
        isTimeBased = false,
        copyCount = copyCount
    ) {
        this.name = name
        this.value = value
    }

    constructor(
        from: WebViewVitalEvent,
        isTerminationOverride: Boolean? = null
    ) : super(from, isTerminationOverride) {
        this.name = from.name
        this.value = from.value
    }

    override fun copy(isTerminationOverride: Boolean?): WebViewVitalEvent =
        WebViewVitalEvent(this, isTerminationOverride)
}