package com.instabug.apm.webview.webview_trace.flow

import com.instabug.apm.webview.webview_trace.model.event.WebViewEvent
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.LOAD_DATA
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.LOAD_DATA_WITH_URL
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.LOAD_URL
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.PAGE_FINISHED
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.PAGE_STARTED
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.POST_URL

/**
 * Capturing WebVitals flow
 * WebVitals should be when the following condition is met
 * onPageStarted -> any other events -> onPageFinished: Start capturing WebViewVitals
 */
class WebViewVitalCapturingFlow : WebViewEventFlow {

    companion object {
        private const val STATE_NONE: Byte = 0
        private const val STATE_STARTED: Byte = 1
        private const val STATE_FINISHED: Byte = 2
    }

    private var state: Byte = STATE_NONE

    override fun process(event: WebViewEvent): Boolean {
        when (event.id) {
            LOAD_URL, POST_URL, LOAD_DATA, LOAD_DATA_WITH_URL -> resetState()
            PAGE_STARTED -> processPageStartedEvent()
            PAGE_FINISHED -> processPageFinishedEvent()
            else -> processOtherEvent()
        }
        return true
    }

    private fun processPageStartedEvent() {
        state = STATE_STARTED
    }

    private fun processPageFinishedEvent() {
        if (state != STATE_NONE) {
            state = STATE_FINISHED
        }
    }

    private fun processOtherEvent() {
        if (state != STATE_STARTED) {
            resetState()
        }
    }

    private fun resetState() {
        state = STATE_NONE
    }

    override fun finished(): Boolean {
        return state == STATE_FINISHED
    }

    override fun getPendingEvent(): WebViewEvent? = null
}