package com.instabug.apm.webview.webview_trace.flow

import com.instabug.apm.webview.webview_trace.model.event.WebViewEvent

interface WebViewEventFlow {

    /**
     * Process a WebViewEvent
     * @return true if the passed event can be processed as part of the WebViewTrace
     */
    fun process(event: WebViewEvent): Boolean

    /**
     * The specific sequence of events handled by this flow has completed
     */
    fun finished(): Boolean

    /**
     * Get pending events that should be processed after the flow has finished
     */
    fun getPendingEvent(): WebViewEvent?
}