package com.instabug.apm.util;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

import com.instabug.apm.constants.Constants;
import com.instabug.library.diagnostics.IBGDiagnostics;

/**
 * Created by Barakat on 17/09/2020
 */
public class ClassModuleHelper {
    @Nullable
    @SuppressLint("ERADICATE_CONDITION_REDUNDANT_NONNULL")
    public static String getModuleName(Class<?> clazz) {
        String pkgName = null;
        try {
            if (clazz != null && clazz.getPackage() != null) {
                pkgName = clazz.getPackage().getName();
            }
        } catch (Exception e) {
            IBGDiagnostics.reportNonFatalAndLog(e, e.getMessage() + "", Constants.LOG_TAG);
        }
        return pkgName;
    }
}
