package com.instabug.apm.uitrace

import com.instabug.apm.di.Provider
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceEventListener
import com.instabug.apm.webview.webview_trace.manager.WebViewTraceManager
import com.instabug.library.factory.ParameterizedFactory

class WebViewTraceListenerFactoryUiTraceDecorator(
    private val webViewTraceListenerParametrizedFactory: ParameterizedFactory<WebViewTraceEventListener?, Long>,
    private val webViewConfigurationProvider: Provider<WebViewTraceConfigurationProvider?>,
    private val webViewTraceManagerProvider: Provider<WebViewTraceManager?>
) : ParameterizedFactory<WebViewTraceEventListener?, Long> {
    override fun create(type: Long): WebViewTraceEventListener? =
        webViewTraceListenerParametrizedFactory
            .takeIf { webViewConfigurationProvider()?.enabled == true }
            ?.create(type)
            ?.also { webViewTraceManagerProvider()?.registerWebViewEventListener(it) }
}