package com.instabug.apm.screenloading.validator

import com.instabug.apm.configuration.APMConfigurationProvider
import com.instabug.apm.constants.ErrorMessages
import com.instabug.apm.logger.internal.Logger
import com.instabug.apm.sanitization.Validator


class EndScreenLoadingConfigurationValidator(
    private val apmConfigurationProvider: APMConfigurationProvider,
    private val logger: Logger
) : Validator<Unit> {
    override fun isValid(item: Unit): Boolean = apmConfigurationProvider.run {
        when {
            !isAPMFeatureAvailable ->
                setInvalidAndLog(ErrorMessages.END_SCREEN_NOT_DISPATCHED_APM_FEATURE_DISABLED)

            !isAPMSdkEnabled ->
                setInvalidAndLog(ErrorMessages.END_SCREEN_NOT_DISPATCHED_APM_SDK_DISABLED)

            !isUiLoadingMetricsFeatureEnabled ->
                setInvalidAndLog(ErrorMessages.END_SCREEN_NOT_DISPATCHED_AUTO_SCREEN_LOADING_FEATURE_DISABLED)

            !isUiLoadingMetricsSdkEnabled ->
                setInvalidAndLog(ErrorMessages.END_SCREEN_NOT_DISPATCHED_AUTO_SCREEN_LOADING_SDK_DISABLED)

            !isUiTraceSdkEnabled ->
                setInvalidAndLog(ErrorMessages.END_SCREEN_NOT_DISPATCHED_AUTO_TRACES_SDK_DISABLED)

            !isEndScreenLoadingFeatureEnabled ->
                setInvalidAndLog(ErrorMessages.END_SCREEN_NOT_DISPATCHED_END_SCREEN_LOADING_FEATURE_DISABLED)

            else -> true
        }
    }

    private fun setInvalidAndLog(errorMessage: String): Boolean {
        logger.logSDKError(errorMessage)
        return false
    }
}