package com.instabug.apm.networkinterception.sanitization

import com.instabug.apm.model.APMNetworkLog
import com.instabug.apm.networkinterception.configuration.NetworkInterceptionConfigurationProvider
import com.instabug.apm.sanitization.Sanitizer
import com.instabug.library.factory.Factory
import com.instabug.library.networkv2.utils.IBGDomainProvider

class InstabugRequestSanitizerFactory(
    private val networkConfigurationProvider: NetworkInterceptionConfigurationProvider?,
    private val domainProvider: IBGDomainProvider
) : Factory<Sanitizer<APMNetworkLog>?> {
    override fun create(): Sanitizer<APMNetworkLog>? =
        networkConfigurationProvider?.let { config ->
            if (config.isKeywordSanitizationEnabled()) {
                InstabugRequestSanitizer(
                    setOf(
                        domainProvider.getInstabugDomain(),
                        domainProvider.getAPMDomain()
                    ),
                    config.iBGSanitizationKeywords
                )
            } else {
                null
            }
        }
}