package com.instabug.apm.networking.mapping.uitrace;

import com.instabug.apm.cache.model.UiTraceCacheModel;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 Serialize {@link UiTraceCacheModel} to JSON objects / arrays
 */
public interface UiTraceMapper {
    /**
     Serialize a list of {@link UiTraceCacheModel} to a JSON array and return as string

     @param uiTraces the list of uiTraces to be serialized

     @throws JSONException if serializing failed.
     */
    JSONArray toJsonArray(List<UiTraceCacheModel> uiTraces) throws JSONException;

    /**
     Serialize an object of {@link UiTraceCacheModel} to a JSON object and return as string

     @param uiTrace the object of uiTraces to be serialized

     @throws JSONException if serializing failed.
     */
    JSONObject toJson(UiTraceCacheModel uiTrace) throws JSONException;
}
