package com.instabug.apm.networking.mapping.executiontraces

import com.instabug.apm.cache.model.ExecutionTraceCacheModel
import com.instabug.library.map.Mapper
import org.json.JSONArray
import org.json.JSONObject

/**
 * Implementation of [ExecutionTraceCacheModel] serialization
 */
class ExecutionTraceMapperImpl : Mapper<List<ExecutionTraceCacheModel>?, JSONArray?> {

    private fun map(trace: ExecutionTraceCacheModel): JSONObject =
        JSONObject().apply {
            put(TRACE_NAME, trace.name)
            put(TRACE_START_TIME, trace.startTime)
            put(TRACE_DURATION, trace.duration)
            trace.attrs?.takeIf { it.isNotEmpty() }
                ?.let { put(TRACE_ATTRIBUTES, it.toJsonObject()) }
            put(BACKGROUND, trace.startedInBackground())
        }

    override fun map(from: List<ExecutionTraceCacheModel>?): JSONArray? =
        from?.takeIf { it.isNotEmpty() }
            ?.map(::map)
            ?.let { JSONArray(it) }

    private fun Map<String, String>.toJsonObject() =
        JSONObject().also { json ->
            keys.forEach { key ->
                json.put(key, get(key))
            }
        }
    
    companion object {
        private const val TRACE_NAME = "n"
        private const val TRACE_START_TIME = "st"
        private const val TRACE_DURATION = "dmus"
        private const val TRACE_ATTRIBUTES = "att"
        private const val BACKGROUND = "bg"

        @JvmStatic
        fun create(): Mapper<List<ExecutionTraceCacheModel>?, JSONArray?> =
            ExecutionTraceMapperImpl()
    }
}
