package com.instabug.apm.handler.session;

import androidx.annotation.NonNull;

import java.util.Collection;

public interface SessionObserverRegistry {

    /**
     * Adds the specified session observer to this registry if it is not already present
     *
     * @param observer the observer to be added to this registry
     */
    void register(@NonNull APMSessionObserver observer);

    /**
     * Removes the specified session observer from this registry if it is not already present
     *
     * @param observer the observer to be removed from this registry
     */
    void unregister(@NonNull APMSessionObserver observer);

    /**
     * @return all registered session observers
     */
    @NonNull
    Collection<APMSessionObserver> getObservers();
}
