package com.instabug.apm.cache.handler.executiontraces;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.cache.model.ExecutionTraceCacheModel;

import java.util.List;

public interface DanglingExecutionTracesCacheHandler {

    /**
     * Inserts trace in cache with the given name and start time
     *
     * @param trace     the trace to insert
     * @return id of created trace
     */
    boolean insertTrace(@NonNull ExecutionTraceCacheModel trace);

    /**
     * Gets a list of all cached ended traces with limit
     *
     * @param limit max count of retrieved traces
     * @return traces list
     */
    @Nullable
    List<ExecutionTraceCacheModel> getEndedTraces(long limit);

    /**
     * Removes cached traces with a limit
     *
     * @param limit max number of traces to be removed
     */
    void removeEndedTraces(long limit);

    /**
     * Adds new attribute to specific trace
     *
     * @param traceId   id of the associated trace
     * @param traceName name of the associated trace
     * @param key       attribute key
     * @param value     attribute value
     */
    void setAttribute(long traceId, @NonNull String traceName, @NonNull String key, @Nullable String value);

    /**
     * Removes all custom traces with its attributes
     */
    void removeAll();

    /**
     * Removes all un-ended custom traces along side with there attributes
     */
    void removeUnEndedTraces();

    /**
     * Checks whether or not a trace has been ended given its ID
     *
     * @param traceId the id of the trace under test
     * @return true if this trace was ended. False otherwise.
     */
    boolean exists(long traceId);
}
