package com.instabug.apm.appflow

import com.instabug.apm.appStateDispacher.AppStateEventListener
import com.instabug.apm.appStateDispacher.CombinedAppStateEvents
import com.instabug.apm.appflow.usecases.UseCase
import com.instabug.apm.di.Provider
import com.instabug.library.core.eventbus.AppStateEvent
import java.util.concurrent.Executor

class AppFlowAppStateEventListener(
    private val foregroundUseCaseProvider: Provider<UseCase<Pair<AppStateEvent.ForegroundAppStateEvent, AppStateEvent.BackgroundAppStateEvent?>, Unit>?>,
    private val backgroundUseCaseProvider: Provider<UseCase<Unit, Unit>?>,
    private val executor: Executor
) : AppStateEventListener {
    override fun invoke(events: CombinedAppStateEvents) = executor.execute {
        events.currentAppStateEvent?.let { currentEvent ->
            if (currentEvent is AppStateEvent.BackgroundAppStateEvent) {
                backgroundUseCaseProvider()?.invoke(Unit)
            } else if (currentEvent is AppStateEvent.ForegroundAppStateEvent) {
                delegateToForegroundUseCaseIfPossible(events.previousAppStateEvent, currentEvent)
            }
        }
    }

    private fun delegateToForegroundUseCaseIfPossible(
        previousEvent: AppStateEvent?,
        currentEvent: AppStateEvent.ForegroundAppStateEvent
    ) {
        if (previousEvent is AppStateEvent.BackgroundAppStateEvent?) {
            foregroundUseCaseProvider()?.invoke(currentEvent to previousEvent)
        }
    }
}