package com.instabug.apm

import com.instabug.apm.configuration.cp.APMFeature
import com.instabug.apm.configuration.cp.FeatureAvailabilityCallback
import com.instabug.apm.di.ServiceLocator
import com.instabug.apm.logger.APMLogger
import com.instabug.apm.sanitization.AsyncSanitizer
import com.instabug.apm.util.isCurrentPlatformCP
import com.instabug.library.logging.listeners.networklogs.NetworkLogSnapshot

object InternalAPM {
    private val apmImplementation by lazy { ServiceLocator.getApmImplementation() }

    @JvmStatic
    fun _startUiTraceCP(screenName: String, microTimeStamp: Long, traceId: Long) =
        apmImplementation.startUiTraceCP(screenName, microTimeStamp, traceId)

    @JvmStatic
    fun _reportScreenLoadingCP(startTimeStampMicro: Long, durationMicro: Long, uiTraceId: Long) =
        apmImplementation.reportScreenLoadingCP(startTimeStampMicro, durationMicro, uiTraceId)

    @JvmStatic
    fun _endScreenLoadingCP(timeStampMicro: Long, uiTraceId: Long) =
        apmImplementation.endScreenLoadingCP(timeStampMicro, uiTraceId)

    @JvmStatic
    fun _isFeatureEnabledCP(
        @APMFeature feature: String,
        apiName: String,
        callback: FeatureAvailabilityCallback
    ) = apmImplementation.isFeatureEnabledCP(feature, apiName, callback)

    @JvmStatic
    fun _isFeatureEnabledCP(
        @APMFeature feature: String,
        apiName: String
    ) = apmImplementation.isFeatureEnabledCP(feature, apiName)

    @JvmStatic
    fun _registerNetworkLogSanitizer(sanitizer: AsyncSanitizer<NetworkLogSnapshot>?) {
        if (isCurrentPlatformCP) {
            apmImplementation.registerAsyncNetworkLogSanitizer(sanitizer)
        } else {
            APMLogger.logSDKWarning("sanitizer was not registered as it's not allowed to be registered from native app")
        }
    }
}