package com.instabug.apm.networkinterception.sanitization

import android.net.Uri
import com.instabug.apm.model.APMNetworkLog
import com.instabug.apm.sanitization.Sanitizer
import com.instabug.library.diagnostics.IBGDiagnostics

class InstabugRequestSanitizer(
    private val instabugDomains: Set<String>,
    private val sanitizationQueries: Set<String>
) : Sanitizer<APMNetworkLog> {

    override fun sanitize(item: APMNetworkLog): APMNetworkLog =
        item.apply {
            try {
                val originalUri = url?.let { Uri.parse(it) }
                if (originalUri?.hasInstabugDomain() == true) {
                    url = originalUri.sanitize().toString()
                }
            } catch (exception: Exception) {
                IBGDiagnostics.reportNonFatal(exception, "failed to parse string to uri: $url")
            }
        }

    private fun Uri.sanitize(): Uri {
        val newUri = buildUpon().clearQuery()
        val keywords = sanitizationQueries.map { it.lowercase() }
        queryParameterNames.asSequence()
            .filterNot { it.lowercase() in keywords }
            .forEach { newUri.appendQueryParameter(it, getQueryParameter(it)) }
        return newUri.build()
    }

    private fun Uri.hasInstabugDomain(): Boolean =
        instabugDomains.any { host.equals(it, true)}
}