package com.instabug.apm.networking.mapping.networklog;

import androidx.annotation.NonNull;

import com.instabug.apm.model.APMNetworkLog;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.List;

public interface APMNetworkLogMapper {

    /**
     * Serializes list of @{@link APMNetworkLog} to @{@link JSONArray}
     *
     * @param apmNetworkLogList list of apm netwok logs to be serialized
     * @return Json array of serialized apm network logs
     * @throws JSONException when serialization fails
     */
    JSONArray toJsonArray(@NonNull List<APMNetworkLog> apmNetworkLogList) throws JSONException;
}
