package com.instabug.apm.appflow

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider
import com.instabug.apm.appflow.handler.AppFlowHandler
import com.instabug.apm.appflow.model.AppFlowCacheModel
import com.instabug.apm.cache.model.SessionCacheModel
import com.instabug.apm.cache.model.SessionMetaData
import com.instabug.apm.networking.mapping.sessions.SessionModelFiller

class AppFlowSessionModelFiller(
    private val handler: AppFlowHandler,
    private val configurationProvider: AppFlowConfigurationProvider
) : SessionModelFiller {

    override fun fill(sessionId: String, sessionCacheModel: SessionCacheModel) {
        val appFlows = handler.get(sessionId)
        val appFlowsRequestLimit = configurationProvider.requestLimit
        getTrimmedAppFlows(appFlows, appFlowsRequestLimit).also {
            updateSessionMetadataIfPossible(
                sessionCacheModel.sessionMetaData,
                it.size,
                appFlows.size
            )
            sessionCacheModel.appFlows = it
        }
    }

    private fun getTrimmedAppFlows(appFlows: List<AppFlowCacheModel>, requestLimit: Int) = appFlows
        .takeIf { it.size > requestLimit }
        ?.sortedByDescending { it.startTimeStampMicro }
        ?.take(requestLimit)
        ?: appFlows

    private fun updateSessionMetadataIfPossible(
        metadata: SessionMetaData?,
        trimmedCount: Int,
        originalCount: Int
    ) = metadata
        ?.takeIf { trimmedCount < originalCount }
        ?.run {
            appFlowTotalCount = originalCount
            appFlowDroppedCountRequestLimit = originalCount - trimmedCount
        }

}