/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.model;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0000J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/instabug/apm/model/EventTimeMetricCapture;", "", "()V", "nanoTime", "", "timeStampMillis", "getDurationMicroStartingFrom", "other", "getDurationMillisStartingFrom", "getDurationNanoFrom", "getMicroTime", "getNanoTime", "getTimeStampMicro", "getTimeStampMillis", "instabug-apm_defaultUiRelease"})
public class EventTimeMetricCapture {
    private final long nanoTime = System.nanoTime();
    private final long timeStampMillis = System.currentTimeMillis();

    public long getNanoTime() {
        return this.nanoTime;
    }

    public long getMicroTime() {
        return this.nanoTime / (long)1000;
    }

    public long getTimeStampMillis() {
        return this.timeStampMillis;
    }

    public long getTimeStampMicro() {
        return this.timeStampMillis * (long)1000;
    }

    public final long getDurationMillisStartingFrom(@NotNull EventTimeMetricCapture eventTimeMetricCapture) {
        Intrinsics.checkNotNullParameter((Object)eventTimeMetricCapture, (String)"other");
        return TimeUnit.NANOSECONDS.toMillis(this.getDurationNanoFrom(eventTimeMetricCapture));
    }

    public final long getDurationMicroStartingFrom(@NotNull EventTimeMetricCapture eventTimeMetricCapture) {
        Intrinsics.checkNotNullParameter((Object)eventTimeMetricCapture, (String)"other");
        return TimeUnit.NANOSECONDS.toMicros(this.getDurationNanoFrom(eventTimeMetricCapture));
    }

    public final long getDurationNanoFrom(@NotNull EventTimeMetricCapture eventTimeMetricCapture) {
        Intrinsics.checkNotNullParameter((Object)eventTimeMetricCapture, (String)"other");
        return this.nanoTime - eventTimeMetricCapture.nanoTime;
    }
}

