package com.instabug.apm.sync;

import com.instabug.apm.handler.executiontraces.ExecutionTracesHandlerImpl;

/**
 * APM data syncing manager, responsible to check the sync intervals and trigger APM sync requests
 */
public interface APMSyncManager {

    /**
     * Start syncing APM data if the sync interval passed
     *
     * @see ExecutionTracesHandlerImpl
     * @see com.instabug.apm.constants.DefaultValues#SYNC_INTERVAL
     */
    void start();

    /**
     * Start syncing APM data bypassing the sync checks
     *
     * @param bypass flag to bypass the sync checks
     * @see ExecutionTracesHandlerImpl
     * @see com.instabug.apm.constants.DefaultValues#SYNC_INTERVAL
     */
    void start(boolean bypass);

    /**
     * Check if APM sync interval has passed since last done sync.
     *
     * @return {@code true} if the time since last sync was done is larger than or equal to the {@code SYNC_INTERVAL},
     * false otherwise.
     *
     * @see com.instabug.apm.constants.DefaultValues#SYNC_INTERVAL
     */
    boolean shouldSync();
}
