package com.instabug.apm.model;

import static com.instabug.apm.model.LogLevel.DEBUG;
import static com.instabug.apm.model.LogLevel.ERROR;
import static com.instabug.apm.model.LogLevel.INFO;
import static com.instabug.apm.model.LogLevel.NONE;
import static com.instabug.apm.model.LogLevel.VERBOSE;
import static com.instabug.apm.model.LogLevel.WARNING;

import androidx.annotation.IntDef;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Keep
@IntDef({NONE, ERROR, WARNING, INFO, DEBUG, VERBOSE})
@Retention(RetentionPolicy.SOURCE)
public @interface LogLevel {

    /**
     * Priority constant to disable all APM printed logs.
     */
    int NONE = 0;
    /**
     * Priority constant for APM error logs.
     */
    int ERROR = 1;
    /**
     * Priority constant for APM warning logs
     */
    int WARNING = 2;
    /**
     * Priority constant for APM info logs
     */
    int INFO = 3;
    /**
     * Priority constant for APM debug logs
     */
    int DEBUG = 4;
    /**
     * Priority constant for APM verbose logs
     */
    int VERBOSE = 5;

    final class Resolver {

        private Resolver() {
            //utility class
        }

        @NonNull
        public static String resolve(@LogLevel int level) {
            switch (level) {
                case NONE:
                    return "NONE";
                case ERROR:
                    return "ERROR";
                case WARNING:
                    return "WARNING";
                case INFO:
                    return "INFO";
                case DEBUG:
                    return "DEBUG";
                case VERBOSE:
                    return "VERBOSE";
                default:
                    return "UNKNOWN";
            }
        }
    }
}