package com.instabug.apm.handler.uitrace.customuitraces;

import android.app.Activity;
import android.os.Looper;

import com.instabug.library.Instabug;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 Handle the custom ui traces
 */
public interface CustomUiTraceHandler {

    /**
     * Starts the ui tracing with the given name
     *
     * @param name     ui trace name.
     * @param activity current activity where the trace is starting, used to register broadcast receivers.
     * @param callerThreadLooper looper of the caller thread
     */
    void startUiTrace(@NonNull String name, Activity activity, @Nullable Looper callerThreadLooper);

    /**
     * Ends the current ui tracing
     *
     * @param activity current activity where the trace is ending, used to unregister broadcast receivers and to get some contextual data.
     * @param callerThreadLooper looper of the caller thread
     */
    void endUiTrace(Activity activity, @Nullable Looper callerThreadLooper);

    /**
     * Gets (if any) currently running ui traces
     *
     * @return currently running ui trace if any, null if there is no running ui traces
     */
    @Nullable
    String getCurrentUiTrace();

    /**
     * Force stop and ignore the currently running {@link com.instabug.apm.cache.model.UiTraceCacheModel} if the SDK was disabled
     *
     * @see Instabug#disable()
     */
    void forceStop();
}
