package com.instabug.apm.constants;

import androidx.annotation.IntDef;
import androidx.annotation.StringDef;

public interface UiLoadingMetric {

    String TIME_STAMP = "_st";
    String STAGE_CREATED_DURATION_MICRO = "ac_on_c_mus";
    String STAGE_CREATED_TIMESTAMP_MICRO = STAGE_CREATED_DURATION_MICRO + TIME_STAMP;
    String STAGE_STARTED_DURATION_MICRO = "ac_on_st_mus";
    String STAGE_STARTED_TIMESTAMP_MICRO = STAGE_STARTED_DURATION_MICRO + TIME_STAMP;
    String STAGE_RESUMED_DURATION_MICRO = "ac_on_r_mus";
    String STAGE_RESUMED_TIMESTAMP_MICRO = STAGE_RESUMED_DURATION_MICRO + TIME_STAMP;
    String STAGE_CUSTOM_END_LOADING_DURATION_MICRO = "esl_mus";
    String STAGE_CUSTOM_END_LOADING_TIMESTAMP_MICRO = STAGE_CUSTOM_END_LOADING_DURATION_MICRO + TIME_STAMP;

    int ON_ACTIVITY_PRE_CREATED = 0;
    int ON_ACTIVITY_CREATED = 1;
    int ON_ACTIVITY_POST_CREATED = 2;
    int ON_ACTIVITY_PRE_STARTED = 3;
    int ON_ACTIVITY_STARTED = 4;
    int ON_ACTIVITY_POST_STARTED = 5;
    int ON_ACTIVITY_PRE_RESUMED = 6;
    int ON_ACTIVITY_RESUMED = 7;
    int ON_ACTIVITY_POST_RESUMED = 8;
    int ON_ACTIVITY_RESUMED_POST_RUN = 9;
    int ON_CUSTOM_SCREEN_LOADING_END = 10;

    int ACTIVITY_EVENTS_COUNT = 11;

    @StringDef({
            STAGE_CREATED_DURATION_MICRO,
            STAGE_CREATED_TIMESTAMP_MICRO,
            STAGE_STARTED_DURATION_MICRO,
            STAGE_STARTED_TIMESTAMP_MICRO,
            STAGE_RESUMED_DURATION_MICRO,
            STAGE_RESUMED_TIMESTAMP_MICRO,
            STAGE_CUSTOM_END_LOADING_DURATION_MICRO,
            STAGE_CUSTOM_END_LOADING_TIMESTAMP_MICRO
    })
    @interface Stages { }

    @IntDef({
            ON_ACTIVITY_PRE_CREATED,
            ON_ACTIVITY_CREATED,
            ON_ACTIVITY_POST_CREATED,
            ON_ACTIVITY_PRE_STARTED,
            ON_ACTIVITY_STARTED,
            ON_ACTIVITY_POST_STARTED,
            ON_ACTIVITY_PRE_RESUMED,
            ON_ACTIVITY_RESUMED,
            ON_ACTIVITY_POST_RESUMED,
            ON_ACTIVITY_RESUMED_POST_RUN,
            ON_CUSTOM_SCREEN_LOADING_END
    })
    @interface ActivityEvents { }
}
