package com.instabug.apm.compose.compose_spans.model.transform

import android.content.ContentValues
import com.instabug.apm.compose.compose_spans.model.ComposeSpansCacheModel
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMComposeSpansEntry
import com.instabug.library.map.Mapper

class SpansCacheContentValueMapper: Mapper<Pair<ComposeSpansCacheModel, String>, ContentValues> {

    override fun map(from: Pair<ComposeSpansCacheModel, String>): ContentValues =
        ContentValues().apply {
            val model = from.first
            val sessionId = from.second
            put(APMComposeSpansEntry.COLUMN_NAME, model.name)
            put(APMComposeSpansEntry.COLUMN_SPANS, model.spansJsonString)
            put(APMComposeSpansEntry.COLUMN_SESSION_ID, sessionId)
        }
}