package com.instabug.apm.compose.compose_spans.model.transform

import com.instabug.apm.compose.compose_spans.model.ComposeSpansCacheModel
import com.instabug.library.map.Mapper
import org.json.JSONArray
import org.json.JSONObject

class ComposeSpansListToJsonArrayMapper: Mapper<List<ComposeSpansCacheModel>?, JSONArray?> {

    override fun map(from: List<ComposeSpansCacheModel>?): JSONArray? =
        kotlin.runCatching {
            from?.takeIf { it.isNotEmpty() }
                ?.mapNotNull { it.toJsonObject() }
                ?.let { JSONArray(it) }
        }.getOrNull()

    private fun ComposeSpansCacheModel.toJsonObject(): JSONObject? =
        takeIf { !spansJsonString.isNullOrEmpty() }
            ?.let { JSONObject() }
            ?.also { jsonObject ->
                jsonObject.put(COMPOSABLE_NAME_KEY, name)
                jsonObject.put(STAGES_KEY, JSONArray(spansJsonString))
            }
}