package com.instabug.apm.compose.compose_spans.configuration

import com.instabug.apm.configuration.ConfigurationHandler
import com.instabug.apm.logger.APMLogger
import com.instabug.library.util.extenstions.runOrLogError
import org.json.JSONObject

class ComposeSpansConfigurationHandler(
    private val composeConfigurationProvider: ComposeSpansConfigurationProvider
) : ConfigurationHandler {
    override fun handleConfigurations(configsJson: JSONObject?) {
        configsJson?.runOrLogError {
            if (has(KEY_COMPOSE_FEATURE_BE)) parseComposeConfigs()
            else handleNullConfigurationsObject()
        }
    }

    private fun JSONObject.parseComposeConfigs() {
        optJSONObject(KEY_COMPOSE_FEATURE_BE)?.run {
            optBoolean(KEY_COMPOSE_SPANS_ENABLED_BE, DEFAULT_COMPOSE_FEATURE_ENABLED).let {
                composeConfigurationProvider.featureEnabled = it
                if (!it) reset() else cacheComposeConfigs()
            }
        }
    }

    private fun JSONObject.cacheComposeConfigs() {
        composeConfigurationProvider.run {
            composeCustomLayoutBEEnabled = optBoolean(
                KEY_COMPOSE_CUSTOM_LAYOUT_ENABLED_BE,
                DEFAULT_COMPOSE_CUSTOM_LAYOUT_BE_ENABLED
            )
            requestLimit =
                optInt(KEY_COMPOSE_REQUEST_LIMIT_BE, DEFAULT_COMPOSE_REQUEST_LIMIT)
            storeLimit =
                optInt(KEY_COMPOSE_STORE_LIMIT_BE, DEFAULT_COMPOSE_STORE_LIMIT)
        }

    }

    private fun handleNullConfigurationsObject() {
        APMLogger.logSDKProtected("Can't parse compose spans configurations, object is null.")
        reset()
    }

    override fun reset() {
        composeConfigurationProvider.reset()
    }
}