package com.instabug.apm.webview.webview_trace.configuration

import com.instabug.apm.configuration.APMConfigurationProvider
import com.instabug.apm.configuration.APMPreferencePropertyFactory
import com.instabug.library.util.LimitConstraintApplier

class WebViewTraceConfigurationProviderImpl(
    private val apmConfig: APMConfigurationProvider,
    private val limitApplier: LimitConstraintApplier,
    preferencePropertyFactory: APMPreferencePropertyFactory,
): WebViewTraceConfigurationProvider {

    private val featureEnabledPref = preferencePropertyFactory.create(
        KEY_WEB_VIEW_TRACE_FEATURE_ENABLED,
        DEFAULT_WEB_VIEW_FEATURE_ENABLED
    )

    private val requestLimitPref = preferencePropertyFactory.create(
        KEY_WEB_VIEW_TRACE_REQUEST_LIMIT,
        DEFAULT_WEB_VIEW_REQUEST_LIMIT
    )

    private val storeLimitPref = preferencePropertyFactory.create(
        KEY_WEB_VIEW_TRACE_STORE_LIMIT,
        DEFAULT_WEB_VIEW_STORE_LIMIT
    )

    private val maxCallbackThresholdMsPref = preferencePropertyFactory.create(
        KEY_WEB_VIEW_TRACE_MAX_CALLBACK_THRESHOLD,
        DEFAULT_WEB_VIEW_MAX_CALLBACK_THRESHOLD_MS
    )

    private val partialViewEnabledPref = preferencePropertyFactory.create(
        KEY_WEB_VIEW_TRACE_PARTIAL_FEATURE_ENABLED,
        DEFAULT_WEB_VIEW_PARTIAL_FEATURE_ENABLED
    )

    private val partialViewPercentagePref = preferencePropertyFactory.create(
        KEY_WEB_VIEW_TRACE_PARTIAL_VIEW_PERCENTAGE,
        DEFAULT_WEB_VIEW_PARTIAL_PERCENTAGE
    )

    private var _requestLimit: Int by requestLimitPref
    private var _storeLimit: Int by storeLimitPref

    override var featureEnabled: Boolean by featureEnabledPref

    override var sdkEnabled: Boolean = DEFAULT_WEB_VIEW_SDK_ENABLED

    override var requestLimit: Int
        set(value) {
            _requestLimit = value
        }
        get() = limitApplier.applyConstraints(_requestLimit)

    override var storeLimit: Int
        set(value) {
            _storeLimit = value
        }
        get() = limitApplier.applyConstraints(_storeLimit)

    override var maxCallbackThresholdMs: Int by maxCallbackThresholdMsPref

    override var partialViewEnabled: Boolean by partialViewEnabledPref

    override var partialViewPercentage: Float by partialViewPercentagePref

    override val enabled: Boolean
        get() = apmConfig.isUiTraceEnabled &&
                apmConfig.isAutoUiLoadingMetricsEnabled &&
                featureEnabled &&
                sdkEnabled

    override fun reset() {
        featureEnabledPref.clear()
        requestLimitPref.clear()
        storeLimitPref.clear()
        maxCallbackThresholdMsPref.clear()
        partialViewEnabledPref.clear()
        partialViewPercentagePref.clear()
    }
}