package com.instabug.apm.util.view;

import android.app.Activity;

import com.instabug.library._InstabugActivity;
import com.instabug.library.core.ui.InstabugBaseFragment;

import androidx.fragment.app.Fragment;

/**
 Helper class identify if the view is an Instabug view
 */

public class InstabugViews {

    /***
     * Helper method if the fragment is an Instabug view, Instabug has two base fragment that are widely used in the SDK
     * ImageAttachmentViewerFragment is the only fragment that is not extending any of the SDK base fragments.
     *
     * @param fragment the fragment under test.
     * @return true if the fragment was one of Instabug fragment
     **/
    public static boolean isInstabugFragment(Fragment fragment) {
        return (fragment instanceof InstabugBaseFragment) ||
                (fragment instanceof com.instabug.library.InstabugBaseFragment) ||
                (fragment.getClass().getName().contains("ImageAttachmentViewerFragment"));
    }

    /***
     * Helper method if the activity is an Instabug view
     * @param activity the activity under test.
     * @return true if the activity was one of Instabug activity
     * */
    public static boolean isInstabugActivity(Activity activity) {
        return (activity instanceof _InstabugActivity);
    }
}
