package com.instabug.apm.util.connection;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

import androidx.annotation.Nullable;

import com.instabug.apm.di.ServiceLocator;

public class ConnectionUtils {

    /**
     * Gets current connection radio
     *
     * @return wifi is connected to wifi, radio type if connected to data,
     * null if not connected
     */
    @Nullable
    public static String getRadio() {
        try {
            Context context = ServiceLocator.getContext();
            if (context != null) {
                ConnectivityManager cm =
                        (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
                NetworkInfo info;
                if (cm != null) {
                    info = cm.getActiveNetworkInfo();
                } else {
                    return null;
                }
                if (info == null)
                    return null;
                if (info.getType() == ConnectivityManager.TYPE_WIFI)
                    return "wifi";
                if (info.getType() == ConnectivityManager.TYPE_MOBILE) {
                    int networkType = info.getSubtype();
                    switch (networkType) {
                        case TelephonyManager.NETWORK_TYPE_GPRS:
                        case TelephonyManager.NETWORK_TYPE_EDGE:
                        case TelephonyManager.NETWORK_TYPE_CDMA:
                        case TelephonyManager.NETWORK_TYPE_1xRTT:
                        case TelephonyManager.NETWORK_TYPE_IDEN:
                        case TelephonyManager.NETWORK_TYPE_GSM:
                            return "2G";
                        case TelephonyManager.NETWORK_TYPE_UMTS:
                        case TelephonyManager.NETWORK_TYPE_HSUPA:
                        case TelephonyManager.NETWORK_TYPE_EVDO_A:
                        case TelephonyManager.NETWORK_TYPE_EVDO_0:
                        case TelephonyManager.NETWORK_TYPE_HSDPA:
                        case TelephonyManager.NETWORK_TYPE_HSPA:
                        case TelephonyManager.NETWORK_TYPE_EVDO_B:
                        case TelephonyManager.NETWORK_TYPE_EHRPD:
                        case TelephonyManager.NETWORK_TYPE_HSPAP:
                        case TelephonyManager.NETWORK_TYPE_TD_SCDMA:
                            return "3G";
                        case TelephonyManager.NETWORK_TYPE_LTE:
                        case TelephonyManager.NETWORK_TYPE_IWLAN:
                        case 19:
                            return "4G";
                        case TelephonyManager.NETWORK_TYPE_NR:
                            return "5G";
                        default:
                            return "UNKNOWN";
                    }
                }
                return null;
            }
        } catch (Exception e) {
            ServiceLocator.getApmLogger().w("Something went wrong while getting network info" + e);
        }
        return null;
    }

    /**
     * Gets current sim operator name
     *
     * @return carrier name
     */
    @Nullable
    public static String getCarrier() {
        Context context = ServiceLocator.getContext();
        if (context != null) {
            TelephonyManager telephonyManager =
                    (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            if (telephonyManager != null) {
                return telephonyManager.getSimOperatorName();
            }
        }
        return null;
    }
}
