package com.instabug.apm.screenloading.validator

import com.instabug.apm.cache.model.UiLoadingModel
import com.instabug.apm.constants.UiLoadingMetric
import com.instabug.apm.constants.UiLoadingMetric.Stages
import com.instabug.apm.sanitization.Validator

class NativeScreenLoadingStagesValidator : Validator<UiLoadingModel> {

    @Stages
    private val mandatoryStagesKeys = arrayOf(
        UiLoadingMetric.STAGE_CREATED_DURATION_MICRO,
        UiLoadingMetric.STAGE_STARTED_DURATION_MICRO,
        UiLoadingMetric.STAGE_RESUMED_DURATION_MICRO,
        UiLoadingMetric.STAGE_CREATED_TIMESTAMP_MICRO,
        UiLoadingMetric.STAGE_STARTED_TIMESTAMP_MICRO,
        UiLoadingMetric.STAGE_RESUMED_TIMESTAMP_MICRO
    )

    override fun isValid(item: UiLoadingModel): Boolean = mandatoryStagesKeys
        .takeUnless { item.stages.isNullOrEmpty() }
        ?.asSequence()
        ?.map { item.stages?.get(it) }
        ?.all { it != null && it > 0 }
        ?: false
}