package com.instabug.apm.notifiers;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class APMSessionCreatedNotifier {

    private static Set<APMSessionCreatedCallback> callbacks;

    public synchronized static void register(APMSessionCreatedCallback callback) {
        if (callbacks == null) {
            callbacks = Collections.newSetFromMap(new ConcurrentHashMap<APMSessionCreatedCallback, Boolean>());
        }
        callbacks.add(callback);
    }

    public synchronized static void unregister(APMSessionCreatedCallback callback) {
        if (callbacks != null) {
            callbacks.remove(callback);
        }
    }

    public synchronized static void notifyAPMSessionCreated(String sessionID) {
        if (callbacks != null) {
            for (APMSessionCreatedCallback callback : callbacks) {
                callback.onSessionCreated(sessionID);
            }
        }
    }
}
