package com.instabug.apm.handler.experiment

interface ExperimentHandler {

    /**
     * Store experiments and their total count in a background thread and return immediately
     */
    fun storeExperimentsAsync(sessionId: String)

    /**
     * Get sessions couple to the APM session with the passed ID,
     * The call is executed on a background and blocks the current thread
     */
    fun getSessionExperimentsAsync(sessionId: String): List<String>?

    /**
     * Clear all stored experiments that are coupled to APM sessions in a background thread
     */
    fun clearAllExperimentsAsync()

}