package com.instabug.apm.configuration.cp

import com.instabug.apm.di.ServiceLocator
import com.instabug.apm.screenloading.di.ScreenLoadingServiceLocator

fun interface FeatureAvailabilityCallback {
    operator fun invoke(isFeatureAvailable: Boolean)
}

object APMCPConfigurationProvider {

    fun getFeatureAvailability(
        @APMFeature feature: String,
        apiName: String,
        callback: FeatureAvailabilityCallback,
    ) = ServiceLocator.getIOExecutor().execute {
        callback(checkAvailability(feature, apiName))
    }

    fun getFeatureAvailability(
        @APMFeature feature: String,
        apiName: String
    ) = checkAvailability(feature, apiName)

    private fun checkAvailability(@APMFeature feature: String, apiName: String): Boolean =
        when (feature) {
            APMFeature.SCREEN_LOADING -> ScreenLoadingServiceLocator
                .ScreenLoadingFeatureAvailabilityChecker.isAvailable(apiName)

            else -> false
        }
}