package com.instabug.apm.appflow.usecases

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider
import com.instabug.apm.appflow.handler.AppFlowHandler
import com.instabug.apm.v3_session_data_readiness.APMSessionReadinessHandler
import com.instabug.apm.v3_session_data_readiness.APMV3SessionSyncNotifier
import com.instabug.library.model.common.Session

class AppFlowNewSessionUseCase(
    private val appFlowHandler: AppFlowHandler,
    private val configurations: AppFlowConfigurationProvider,
    private val appFlowSessionReadinessHandler: APMSessionReadinessHandler?,
    private val apmV3SessionSyncNotifier: APMV3SessionSyncNotifier?
) :
    UseCase<Pair<Session, Session?>, Unit> {
    override fun invoke(param: Pair<Session, Session?>) {
        param.takeIf { configurations.enabled }
            ?.let { Pair(it.first.id, it.second?.id) }
            ?.let { (currentSessionId, previousSessionId) ->
                appFlowHandler.updateCurrentSession(currentSessionId)
                appFlowHandler.trimAndUpdateCounts(currentSessionId, previousSessionId)
                notifyV3SessionReadinessIfHasBlockedSessions()
            }
    }

    private fun notifyV3SessionReadinessIfHasBlockedSessions() = apmV3SessionSyncNotifier
        ?.takeIf { hasBlockedSessions() }
        ?.invoke()

    private fun hasBlockedSessions() =
        appFlowSessionReadinessHandler?.hasBlockedSessions == true
}