/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.apm.appflow.di.h;
import com.instabug.apm.compose.compose_spans.d;
import com.instabug.apm.di.f;
import com.instabug.apm.handler.session.b;
import com.instabug.apm.handler.session.e;
import com.instabug.apm.model.EventTimeMetricCapture;
import com.instabug.apm.v3_session_data_readiness.c;
import com.instabug.library.BuildFieldsProvider;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.InstabugStateEventBus;
import com.instabug.library.core.eventbus.NDKSessionCrashedEvent;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.model.common.Session;
import com.instabug.library.sessionV3.providers.FeatureSessionDataController;
import com.instabug.library.sessionV3.providers.FeatureSessionDataControllerHost;
import com.instabug.library.sessionV3.providers.FeatureSessionLazyDataProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivexport.disposables.CompositeDisposable;
import io.reactivexport.functions.Consumer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class APMPlugin
extends Plugin
implements com.instabug.apm.handler.session.a,
FeatureSessionDataControllerHost,
FeatureSessionLazyDataProvider {
    public static final Object lock = new Object();
    private boolean isFirstLaunch = false;
    private final com.instabug.apm.handler.session.c sessionHandler;
    private final com.instabug.apm.logger.internal.a apmLogger;
    @Nullable
    private CompositeDisposable sdkCoreEventsSubscriberDisposable;
    @Nullable
    IBGCompositeDisposable compositeDisposable;
    com.instabug.apm.fragment.c fragmentSpansHelper = f.e0();
    @Nullable
    @VisibleForTesting
    IBGDisposable apmSdkStateObserver;

    public APMPlugin() {
        this.sessionHandler = f.z0();
        this.apmLogger = f.q();
    }

    private void handleAppFlowsAppLaunch() {
        com.instabug.apm.appflow.manager.a a2 = h.a.J();
        if (a2 != null) {
            a2.c();
        }
    }

    private static void registerDataReadinessHandlers() {
        c[] cArray = (c[])f.j().invoke();
        if (cArray == null) {
            return;
        }
        for (c c2 : cArray) {
            if (c2 == null) continue;
            c2.d();
        }
    }

    private boolean shouldDependOnV3Session(com.instabug.apm.configuration.c c2, @Nullable Session session) {
        return session != null && session.getVersion().equals("V2") && c2.z();
    }

    private void unRegisterApmSDKStateEventBus() {
        IBGDisposable iBGDisposable = this.apmSdkStateObserver;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.apmSdkStateObserver = null;
        }
    }

    private void registerFragmentLifecycleEventListener() {
        this.fragmentSpansHelper.b();
    }

    private void startComposeSpansManager() {
        d d2 = com.instabug.apm.compose.compose_spans.f.a.l();
        if (d2 != null) {
            d2.a();
        }
    }

    private void startUiTracesManager() {
        com.instabug.apm.uitrace.manager.a a2 = com.instabug.apm.uitrace.di.h.n();
        if (a2 != null) {
            a2.a();
        }
    }

    private void startScreenLoadingManager() {
        com.instabug.apm.screenloading.manager.a a2 = com.instabug.apm.screenloading.di.e.e();
        if (a2 != null) {
            a2.a();
        }
    }

    private void handleComposeSpansStateChange() {
        d d2 = com.instabug.apm.compose.compose_spans.f.a.l();
        if (d2 != null) {
            d2.b();
        }
    }

    private void handleUiTracesStateChanged() {
        com.instabug.apm.uitrace.manager.a a2 = com.instabug.apm.uitrace.di.h.n();
        if (a2 != null) {
            a2.b();
        }
    }

    private void handleScreenLoadingStateChanged() {
        com.instabug.apm.screenloading.manager.a a2 = com.instabug.apm.screenloading.di.e.e();
        if (a2 != null) {
            a2.b();
        }
    }

    private void handleWebViewTracesStateChange() {
        com.instabug.apm.webview.webview_trace.manager.a a2 = f.X0();
        if (a2 != null) {
            a2.b();
        }
    }

    private void startAppFlowManager() {
        com.instabug.apm.appflow.manager.a a2 = h.a.J();
        if (a2 != null) {
            a2.a();
        }
    }

    private void handleAppFlowStateChange() {
        com.instabug.apm.appflow.manager.a a2 = h.a.J();
        if (a2 != null) {
            a2.b();
        }
    }

    private void unRegisterFragmentLifecycleEventListener() {
        this.fragmentSpansHelper.a();
    }

    private void registerSessionCrashHandler() {
        if (f.n().k() && !(Thread.getDefaultUncaughtExceptionHandler() instanceof b)) {
            InstabugSDKLogger.d((String)"IBG-APM", (String)"setting Uncaught Exception Handler APMUncaughtExceptionHandler");
            Thread.setDefaultUncaughtExceptionHandler(new b());
        }
    }

    private void subscribeToSDKState() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        this.sdkCoreEventsSubscriberDisposable.add(InstabugStateEventBus.getInstance().getEventObservable().subscribe(new Consumer(){

            public void a(InstabugState instabugState) {
                if (instabugState == InstabugState.DISABLED) {
                    a a2 = this;
                    a2.APMPlugin.this.apmLogger.d("Instabug is disabled, purging APM data\u2026");
                    a2.APMPlugin.this.stopRunningMetrics();
                    a2.APMPlugin.this.endSession();
                    a2.APMPlugin.this.purgeData();
                }
            }
        }));
    }

    private void purgeData() {
        f.n().setLastSyncTime(-1L);
        final com.instabug.apm.sync.a a2 = f.t();
        final boolean bl = a2.b();
        f.c("session_purging_thread_executor").execute(new Runnable(){

            @Override
            public void run() {
                a2.a(bl);
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    private void stopRunningMetrics() {
        f.m0().h();
        PoolProvider.postMainThreadTask(() -> {
            if (BuildFieldsProvider.INSTANCE.provideBuildVersion() >= 16) {
                APMPlugin.finalizeScreenLoadingCapturing();
                APMPlugin.endAutomaticUiTraces();
                com.instabug.apm.handler.uitrace.customuitraces.a a2 = f.H();
                if (a2 != null) {
                    a2.h();
                }
            }
        });
    }

    private static void endAutomaticUiTraces() {
        com.instabug.apm.uitrace.manager.a a2 = com.instabug.apm.uitrace.di.h.n();
        if (a2 != null) {
            a2.c();
        }
    }

    private static void finalizeScreenLoadingCapturing() {
        com.instabug.apm.screenloading.manager.a a2 = com.instabug.apm.screenloading.di.e.e();
        if (a2 != null) {
            a2.c();
        }
    }

    private void clearInvalidCache() {
        final com.instabug.apm.handler.executiontraces.a a2 = f.R();
        final com.instabug.apm.handler.networklog.a a3 = f.m0();
        f.c("execution_traces_thread_executor").execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    a2.b();
                    return;
                }
            }
        });
        f.c("network_log_thread_executor").execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (f.n().r()) {
                    Object object = lock;
                    synchronized (object) {
                        a3.b();
                    }
                }
            }
        });
    }

    private void registerConfigurationChange() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        APMPlugin aPMPlugin = this;
        aPMPlugin.sdkCoreEventsSubscriberDisposable.add(f.s0().subscribe(new Consumer(){

            public void a(NDKSessionCrashedEvent nDKSessionCrashedEvent) {
                APMPlugin.this.sessionHandler.a(nDKSessionCrashedEvent.getSessionId(), TimeUnit.MILLISECONDS.toMicros(nDKSessionCrashedEvent.getSessionDuration()), 1);
            }
        }));
        aPMPlugin.getOrCreateCompositeDisposable().add(this.subscribeToSdkCoreEvents());
    }

    @NonNull
    private IBGDisposable subscribeToSdkCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(this::handleCoreEvent);
    }

    private void handleCoreEvent(IBGSdkCoreEvent iBGSdkCoreEvent) {
        if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.V3Session) {
            this.handleV3SessionEvent((IBGSdkCoreEvent.V3Session)iBGSdkCoreEvent);
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.FeaturesFetched) {
            this.handleFeaturesFetched(((IBGSdkCoreEvent.FeaturesFetched)iBGSdkCoreEvent).getResponse());
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.CrossPlatformCrashed) {
            this.updateCurrentSession();
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.CrossPlatformScreenChanged) {
            this.handleCPScreenChanged((IBGSdkCoreEvent.CrossPlatformScreenChanged)iBGSdkCoreEvent);
        }
    }

    private void handleCPScreenChanged(IBGSdkCoreEvent.CrossPlatformScreenChanged object) {
        if (SettingsManager.getInstance().getCurrentPlatform() != 8) {
            EventTimeMetricCapture eventTimeMetricCapture;
            String string = object.getScreenName();
            object = eventTimeMetricCapture;
            eventTimeMetricCapture = new EventTimeMetricCapture();
            com.instabug.apm.uitrace.manager.a a2 = com.instabug.apm.uitrace.di.h.n();
            if (a2 != null) {
                Object object2 = object;
                long l2 = ((EventTimeMetricCapture)object2).getTimeStampMicro();
                long l3 = ((EventTimeMetricCapture)object2).getTimeStampMillis();
                a2.a(string, l2, l3);
            }
        }
    }

    private void handleFeaturesFetched(@NonNull String object) {
        boolean bl = f.m().a((String)object);
        object = f.n();
        object.b(InstabugCore.isV3SessionEnabled());
        if (bl && object.x()) {
            object = InstabugCore.getRunningSession();
            if (object != null) {
                APMPlugin aPMPlugin = this;
                e.a(aPMPlugin);
                aPMPlugin.startSession((Session)object);
                aPMPlugin.registerSessionCrashHandler();
            }
            APMPlugin aPMPlugin = this;
            aPMPlugin.registerActivityLifeCycleCallbacks();
            aPMPlugin.registerSessionCrashHandler();
            aPMPlugin.registerFragmentLifecycleEventListener();
        }
        APMPlugin aPMPlugin = this;
        aPMPlugin.handleComposeSpansStateChange();
        aPMPlugin.handleUiTracesStateChanged();
        aPMPlugin.handleScreenLoadingStateChanged();
        aPMPlugin.handleWebViewTracesStateChange();
        aPMPlugin.handleAppFlowStateChange();
    }

    private void handleV3SessionEvent(IBGSdkCoreEvent.V3Session v3Session) {
        if (v3Session instanceof IBGSdkCoreEvent.V3Session.V3SessionStarted) {
            v3Session = InstabugCore.getRunningSession();
            if (v3Session != null) {
                APMPlugin aPMPlugin = this;
                e.a(aPMPlugin);
                aPMPlugin.startSession((Session)v3Session);
                aPMPlugin.registerSessionCrashHandler();
                aPMPlugin.registerAPMSdkStateEventBus();
                aPMPlugin.startComposeSpansManager();
                aPMPlugin.startAppFlowManager();
                aPMPlugin.startUiTracesManager();
                aPMPlugin.startScreenLoadingManager();
            }
        } else if (v3Session instanceof IBGSdkCoreEvent.V3Session.V3SessionFinished) {
            this.endSession();
        }
    }

    private void updateCurrentSession() {
        f.G0().execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugCore.getRunningSession() != null) {
                    APMPlugin.this.sessionHandler.b(1);
                }
            }
        });
    }

    private void registerActivityLifeCycleCallbacks() {
        com.instabug.apm.lifecycle.a a2;
        if (f.n().x() && (this = f.F()) != null && !com.instabug.apm.lifecycle.a.c() && (a2 = f.a((Context)this, false)) != null) {
            ((Application)this.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)a2);
        }
    }

    private void startSession(@NonNull Session session) {
        if (InstabugCore.isV3SessionEnabled() && !session.getVersion().equals("V3")) {
            return;
        }
        this.sessionHandler.a(session);
    }

    private void endSession() {
        this.sessionHandler.b(0);
    }

    @NonNull
    private IBGCompositeDisposable getOrCreateCompositeDisposable() {
        IBGCompositeDisposable iBGCompositeDisposable = this.compositeDisposable;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.compositeDisposable = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    public void init(Context context) {
        APMPlugin aPMPlugin = this;
        super.init(context);
        APMPlugin.registerDataReadinessHandlers();
        aPMPlugin.handleAppFlowsAppLaunch();
    }

    public void wake() {
        com.instabug.apm.configuration.c c2 = f.n();
        if (c2.x() && this.isFirstLaunch) {
            this.clearInvalidCache();
            this.isFirstLaunch = false;
        }
        if (this.shouldDependOnV3Session(c2, (Session)(c2 = InstabugCore.getRunningSession()))) {
            this.apmLogger.a("v2 trying to start apm session while v3 enabled.. skipping");
            return;
        }
        if (c2 != null) {
            APMPlugin aPMPlugin = this;
            e.a(aPMPlugin);
            aPMPlugin.startSession((Session)c2);
            aPMPlugin.registerSessionCrashHandler();
            aPMPlugin.registerFragmentLifecycleEventListener();
            aPMPlugin.startComposeSpansManager();
            aPMPlugin.startAppFlowManager();
            aPMPlugin.startUiTracesManager();
            aPMPlugin.startScreenLoadingManager();
            aPMPlugin.registerAPMSdkStateEventBus();
        } else {
            this.apmLogger.e("APM session not created. Core session is null");
        }
    }

    @VisibleForTesting
    void registerAPMSdkStateEventBus() {
        if (this.apmSdkStateObserver == null) {
            this.apmSdkStateObserver = com.instabug.apm.eventbus.a.a.subscribe(bl -> {
                if (bl.booleanValue()) {
                    this.registerFragmentLifecycleEventListener();
                } else {
                    this.unRegisterFragmentLifecycleEventListener();
                }
                APMPlugin aPMPlugin = this;
                aPMPlugin.handleComposeSpansStateChange();
                aPMPlugin.handleUiTracesStateChanged();
                aPMPlugin.handleScreenLoadingStateChanged();
                aPMPlugin.handleWebViewTracesStateChange();
                aPMPlugin.handleAppFlowStateChange();
            });
        }
    }

    public void stop() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable != null && !compositeDisposable.isDisposed()) {
            this.sdkCoreEventsSubscriberDisposable.dispose();
        }
        if ((this = this.compositeDisposable) != null) {
            this.dispose();
        }
    }

    public void sleep() {
        APMPlugin aPMPlugin = this;
        aPMPlugin.unRegisterApmSDKStateEventBus();
        aPMPlugin.endSession();
    }

    public void start(Context context) {
        APMPlugin aPMPlugin = this;
        aPMPlugin.isFirstLaunch = true;
        aPMPlugin.registerConfigurationChange();
        aPMPlugin.subscribeToSDKState();
        if (Build.VERSION.SDK_INT < 16) {
            this.apmLogger.e("Could not enable Auto UI Trace. Feature is supported on API level 16 and up only.");
        }
    }

    public long getLastActivityTime() {
        return 0L;
    }

    @Override
    @WorkerThread
    public void onNewSessionStarted(@NonNull Session session, @Nullable Session session2) {
        if (session2 != null) {
            f.o0().a(session, session2);
            f.T().a(session, session2);
        }
        f.Z().b();
        f.t().a();
    }

    public boolean isFeatureEnabled() {
        return f.n().x();
    }

    @NonNull
    public FeatureSessionDataController getSessionDataController() {
        return f.x0();
    }

    @NonNull
    public Map<String, Boolean> isDataReady(@NonNull List<String> list) {
        return f.i().isDataReady(list);
    }
}

