package com.instabug.apm.webview.webview_trace.model.event

import androidx.annotation.IntDef
import com.instabug.apm.model.EventTimeMetricCapture
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.ERROR_RECEIVED
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.HTTP_ERROR_RECEIVED
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.LOAD_DATA
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.LOAD_DATA_WITH_URL
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.LOAD_URL
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.OVERRIDE_URL_END
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.OVERRIDE_URL_START
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.PAGE_FINISHED
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.PAGE_STARTED
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.POST_URL
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.SIZE_READY
import com.instabug.apm.webview.webview_trace.model.event.WebViewEventId.Companion.WEB_VITAL


@IntDef(
    LOAD_URL,
    POST_URL,
    LOAD_DATA,
    LOAD_DATA_WITH_URL,
    OVERRIDE_URL_START,
    OVERRIDE_URL_END,
    PAGE_STARTED,
    PAGE_FINISHED,
    ERROR_RECEIVED,
    HTTP_ERROR_RECEIVED,
    WEB_VITAL,
    SIZE_READY
)
annotation class WebViewEventId {
    companion object {
        const val LOAD_URL = 0
        const val POST_URL = 1
        const val LOAD_DATA = 2
        const val LOAD_DATA_WITH_URL = 3
        const val OVERRIDE_URL_START = 4
        const val OVERRIDE_URL_END = 5
        const val PAGE_STARTED = 6
        const val PAGE_FINISHED = 7
        const val ERROR_RECEIVED = 8
        const val HTTP_ERROR_RECEIVED = 9
        const val WEB_VITAL = 10
        const val SIZE_READY = 11
        const val TOTAL_COUNT = 12
    }
}


open class WebViewEvent(
    @WebViewEventId val id: Int,
    val timeCapture: EventTimeMetricCapture,
    val isTermination: Boolean = false,
    val isTimeBased: Boolean = true,
    val copyCount: Int = 0
) {

    constructor(from: WebViewEvent, isTerminationOverride: Boolean? = null) : this(
        from.id,
        from.timeCapture,
        isTermination= isTerminationOverride ?: from.isTermination,
        isTimeBased = from.isTimeBased,
        from.copyCount + 1
    )

    open fun shouldTerminateCurrentTrace(): Boolean {
        return isTermination
    }

    open fun copy(isTerminationOverride: Boolean? = null): WebViewEvent =
        WebViewEvent(this, isTerminationOverride)
}

interface WebViewTraceInitiationEvent {
    val traceId: Long
    val shouldInitiateNewTrace: Boolean
}
