package com.instabug.apm.webview.webview_trace.model

import com.instabug.library.map.Mapper
import org.json.JSONObject

class WebViewVitalsToJsonStringMapper: Mapper<Map<String, Double>?, String?> {
    override fun map(from: Map<String, Double>?): String? =
        from?.filter { it.key in VitalEvents }?.takeIf { it.isNotEmpty() }?.let { vitals ->
            JSONObject().apply {
                putLong(LARGEST_CONTENTFUL_PAINT, vitals)
                putDouble(CUMULATIVE_LAYOUT_SHIFT, vitals)
                putLong(FIRST_INPUT_DELAY, vitals)
            }.toString()
        }

    private fun JSONObject.putLong(key: String, vitalsMap: Map<String, Double>) {
        vitalsMap[key]?.toLong()?.let {
            put(key, it)
        }
    }

    private fun JSONObject.putDouble(key: String, vitalsMap: Map<String, Double>) {
        vitalsMap[key]?.let {
            put(key, it)
        }
    }

    companion object {
        @JvmStatic
        fun create(): Mapper<Map<String, Double>?, String?> = WebViewVitalsToJsonStringMapper()
    }
}