package com.instabug.apm.networking.mapping.sessions

import com.instabug.apm.cache.model.SessionCacheModel
import org.json.JSONObject

interface SessionFeatureJsonFiller  {
    fun addToJsonObject(model: SessionCacheModel, sessionJsonObject: JSONObject)

    companion object {
        inline fun getDropCount(
            storedItemsProvider: () -> List<*>?,
            totalStoredCountProvider: () -> Int,
            droppedRequestLimitCountProvider: () -> Int
        ): Pair<Int, Int> =
            totalStoredCountProvider().takeIf { it > 0 }
                ?.let { totalCount -> totalCount - (storedItemsProvider()?.count() ?: 0) }
                ?.takeIf { it > 0 }
                ?.let { totalDropCount -> (totalDropCount to droppedRequestLimitCountProvider()) }
                ?.takeIf { it.first >= it.second }
                ?.let { (totalDrop, dropRequestLimit) -> (totalDrop - dropRequestLimit) to dropRequestLimit }
                ?: (0 to 0)
    }
}