package com.instabug.apm.networking.mapping.fragment_span

import com.instabug.apm.cache.model.FragmentSpansCacheModel
import com.instabug.apm.cache.model.FragmentSpansEventCacheModel
import com.instabug.apm.cache.model.SessionMetaData
import org.json.JSONArray
import org.json.JSONObject

class FragmentSpanMapperImpl : FragmentSpanMapper {

    override fun toJsonObject(
        fragmentSpans: List<FragmentSpansCacheModel>?,
        metaData: SessionMetaData?
    ): JSONObject? =
        metaData?.let { sessionMetadata ->
            val totalSpansCount = sessionMetadata.fragmentSpansTotalCount
            return if (totalSpansCount != 0) {
                JSONObject().apply {
                    val storedSpansCount = fragmentSpans?.count() ?: 0
                    val droppedCountRequestLimit =
                        sessionMetadata.fragmentSpansDroppedCountRequestLimit
                    val droppedCountStoreLimit =
                        sessionMetadata.getFragmentSpansDroppedCountStoreLimit(
                            storedSpansCount
                        )
                    if (droppedCountRequestLimit > 0) {
                        put(FRAGMENT_SPANS_DROPPED_REQUEST_LIMIT, droppedCountRequestLimit)
                    }
                    if (droppedCountStoreLimit > 0) {
                        put(FRAGMENT_SPANS_DROPPED_STORE_LIMIT, droppedCountStoreLimit)
                    }
                    put(FRAGMENT_SPANS_ARRAY, createFragmentSpansJsonArray(fragmentSpans))
                }
            } else {
                null
            }
        }

    private fun createFragmentSpansJsonArray(spans: List<FragmentSpansCacheModel>?): JSONArray =
        JSONArray().also { jsonArray ->
            spans?.forEach {
                jsonArray.put(createFragmentSpanJsonObject(it))
            }
        }

    private fun createFragmentSpanJsonObject(span: FragmentSpansCacheModel): JSONObject =
        JSONObject().apply {
            put(FRAGMENT_SPANS_FRAGMENT_NAME, span.name)
            put(FRAGMENT_SPANS_STAGES, createFragmentEventsJsonArray(span.events))
        }

    private fun createFragmentEventsJsonArray(events: List<FragmentSpansEventCacheModel>): JSONArray =
        JSONArray().also { jsonArray ->
            events.forEach {
                jsonArray.put(createFragmentEventJsonObject(it))
            }
        }

    private fun createFragmentEventJsonObject(event: FragmentSpansEventCacheModel): JSONObject =
        JSONObject().apply {
            put(FRAGMENT_SPANS_STAGE_NAME, event.name)
            put(FRAGMENT_SPANS_STAGE_START_TIMESTAMP_MICROS, event.startTime)
            put(FRAGMENT_SPANS_STAGE_DURATION_MICROS, event.duration)
        }
}