package com.instabug.apm.handler.uitrace;

import com.instabug.apm.configuration.APMConfigurationProvider;

/**
 Frames' drops callback, notify the owner with delayed frames' durations.
 */
public interface FrameDropsCallback {
    /**
     Called if a UI frame was delayed, takes more than defined duration to render.

     @param frameDuration the duration of delaying frame.

     @see APMConfigurationProvider#getUiTraceSmallDropThreshold()
     */
    void onFrameDrop(long frameDuration);
}
